/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.urn;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import net.silentchaos512.gems.block.urn.BlockSoulUrn;
import net.silentchaos512.gems.block.urn.ContainerSoulUrn;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.item.SoulUrnUpgrades;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;

public class TileSoulUrn
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory,
IHopper {
    private static final int INVENTORY_ROWS_BASE = 2;
    private static final int INVENTORY_ROWS_UPGRADE_1 = 4;
    private static final int INVENTORY_ROWS_UPGRADE_2 = 6;
    private NonNullList<ItemStack> items;
    private NonNullList<UrnUpgrade> upgrades = NonNullList.func_191196_a();
    private int color;
    @Nullable
    private EnumGem gem = null;
    private boolean destroyedByCreativePlayer;
    private boolean cleared;
    private int ticksExisted;

    public TileSoulUrn() {
        this.items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    }

    void setColorAndGem(int color, @Nullable EnumGem gem) {
        this.color = color;
        this.gem = gem;
    }

    void setUpgrades(List<UrnUpgrade> list) {
        this.upgrades.clear();
        this.upgrades.addAll(list);
        int inventoryRows = 2;
        if (UrnUpgrade.ListHelper.contains(this.upgrades, SoulUrnUpgrades.STORAGE_ADVANCED)) {
            inventoryRows = 6;
        } else if (UrnUpgrade.ListHelper.contains(this.upgrades, SoulUrnUpgrades.STORAGE_BASIC)) {
            inventoryRows = 4;
        }
        NonNullList newList = NonNullList.func_191197_a((int)(9 * inventoryRows), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < newList.size() && i < this.items.size(); ++i) {
            newList.set(i, this.items.get(i));
        }
        this.items = newList;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        Block block = Block.func_149634_a((Item)itemStackIn.func_77973_b());
        return !(block instanceof BlockSoulUrn) && !(block instanceof BlockShulkerBox);
    }

    public boolean tryAddItemToInventory(ItemStack stack) {
        if (this.isFull() || !this.func_180462_a(0, stack, EnumFacing.UP)) {
            return false;
        }
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack stackInSlot = this.func_70301_a(slot);
            if (!stackInSlot.func_190926_b() && !stackInSlot.func_77969_a(stack)) continue;
            if (!stackInSlot.func_190926_b()) {
                int amountCanFit = Math.min(stack.func_190916_E(), stackInSlot.func_77976_d() - stackInSlot.func_190916_E());
                stackInSlot.func_190920_e(stackInSlot.func_190916_E() + amountCanFit);
                stack.func_190920_e(stack.func_190916_E() - amountCanFit);
                this.func_70299_a(slot, stackInSlot);
            } else {
                this.func_70299_a(slot, stack.func_77946_l());
                stack.func_190920_e(0);
            }
            return true;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isFull() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockSoulUrn.LidState lid = (BlockSoulUrn.LidState)((Object)ModBlocks.soulUrn.func_176203_a(this.func_145832_p()).func_177229_b(BlockSoulUrn.PROPERTY_LID));
        ++this.ticksExisted;
        SoulUrnState state = new SoulUrnState(this, lid);
        for (UrnUpgrade upgrade : this.upgrades) {
            upgrade.tickTile(state, this.field_145850_b, this.field_174879_c);
        }
        if (!state.itemsAbsorbed && lid.isOpen() && this.ticksExisted % 30 == 0) {
            this.updateHopper();
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSoulUrn(playerInventory, this);
    }

    public String func_174875_k() {
        return "silentgems:soul_urn";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.silentgems.soul_urn";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.saveToNBT(compound);
    }

    public void loadFromNBT(NBTTagCompound compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.items);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
        this.loadColorFromNBT(compound);
        this.loadGemFromNBT(compound);
        this.setUpgrades((List<UrnUpgrade>)UrnUpgrade.ListHelper.load(compound));
    }

    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.items, (boolean)false);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        if (!compound.func_74764_b("Lock") && this.func_174893_q_()) {
            this.func_174891_i().func_180157_a(compound);
        }
        if (this.color != 9985861) {
            compound.func_74768_a("Color", this.color);
        }
        if (this.gem != null) {
            compound.func_74778_a("Gem", this.gem.func_176610_l());
        }
        UrnUpgrade.ListHelper.save(this.upgrades, compound);
        return compound;
    }

    private void loadColorFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Color")) {
            this.color = compound.func_74762_e("Color");
        }
    }

    private void loadGemFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Gem")) {
            String str = compound.func_74779_i("Gem");
            for (EnumGem gem : EnumGem.values()) {
                if (!gem.func_176610_l().equals(str)) continue;
                this.gem = gem;
                break;
            }
        }
    }

    public void func_174888_l() {
        this.cleared = true;
        super.func_174888_l();
    }

    public boolean shouldDrop() {
        return !this.isDestroyedByCreativePlayer() || !this.func_191420_l() || this.func_145818_k_() || this.field_184284_m != null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        if (this.color != 9985861) {
            tags.func_74768_a("Color", this.color);
        }
        if (this.gem != null) {
            tags.func_74778_a("Gem", this.gem.func_176610_l());
        }
        UrnUpgrade.ListHelper.save(this.upgrades, tags);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tags = pkt.func_148857_g();
        this.loadColorFromNBT(tags);
        this.loadGemFromNBT(tags);
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    private boolean updateHopper() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean flag = false;
            if (!this.isFull()) {
                boolean bl = flag = this.pullItems() || flag;
            }
            if (flag) {
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean pullItems() {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)this);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = TileEntityHopper.func_145884_b((IHopper)this);
        if (iinventory != null) {
            EnumFacing enumfacing = EnumFacing.DOWN;
            if (TileSoulUrn.isInventoryEmpty(iinventory, enumfacing)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                for (int i : aint = isidedinventory.func_180463_a(enumfacing)) {
                    if (!TileSoulUrn.pullItemFromSlot(this, iinventory, i, enumfacing)) continue;
                    return true;
                }
            } else {
                int j = iinventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    if (!TileSoulUrn.pullItemFromSlot(this, iinventory, k, enumfacing)) continue;
                    return true;
                }
            }
        } else {
            for (EntityItem entityitem : TileEntityHopper.func_184292_a((World)this.func_145831_w(), (double)this.func_96107_aA(), (double)this.func_96109_aB(), (double)this.func_96108_aC())) {
                if (!TileEntityHopper.func_145898_a(null, (IInventory)this, (EntityItem)entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int i : aint = isidedinventory.func_180463_a(side)) {
                if (isidedinventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.func_70301_a(k).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, EnumFacing direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && TileSoulUrn.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = TileEntityHopper.func_174918_a((IInventory)inventoryIn, (IInventory)hopper, (ItemStack)inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    public NonNullList<UrnUpgrade> getUpgrades() {
        return this.upgrades;
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public EnumGem getGem() {
        return this.gem;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setGem(@Nullable EnumGem gem) {
        this.gem = gem;
    }

    public void setDestroyedByCreativePlayer(boolean destroyedByCreativePlayer) {
        this.destroyedByCreativePlayer = destroyedByCreativePlayer;
    }

    public static class SoulUrnState {
        private final TileSoulUrn tileEntity;
        private final BlockSoulUrn.LidState lidState;
        private boolean itemsAbsorbed = false;

        private SoulUrnState(TileSoulUrn tile, BlockSoulUrn.LidState lidState) {
            this.tileEntity = tile;
            this.lidState = lidState;
        }

        public TileSoulUrn getTileEntity() {
            return this.tileEntity;
        }

        public BlockSoulUrn.LidState getLidState() {
            return this.lidState;
        }

        public boolean isItemsAbsorbed() {
            return this.itemsAbsorbed;
        }

        public void setItemsAbsorbed(boolean itemsAbsorbed) {
            this.itemsAbsorbed = itemsAbsorbed;
        }
    }
}

