/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.gui;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.skills.ToolSkill;

@SideOnly(value=Side.CLIENT)
public class GuiCrosshairs
extends GuiIngame {
    public static final GuiCrosshairs INSTANCE = new GuiCrosshairs(Minecraft.func_71410_x());
    private static final ResourceLocation TEXTURE_CROSSHAIRS = new ResourceLocation("silentgems", "textures/gui/hud.png");

    public GuiCrosshairs(Minecraft mcIn) {
        super(mcIn);
    }

    public void renderOverlay(RenderGameOverlayEvent event, int type, ToolSkill skill) {
        int cost = skill.getCost(null, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, BlockPos.field_177992_a);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (data != null && data.getCurrentChaos() < cost) {
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.field_73839_d.func_110434_K().func_110577_a(TEXTURE_CROSSHAIRS);
        GlStateManager.func_179147_l();
        this.renderCrosshairs(event.getPartialTicks(), event.getResolution(), type);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderCrosshairs(float partialTicks, ScaledResolution resolution, int type) {
        GameSettings gamesettings = this.field_73839_d.field_71474_y;
        if (gamesettings.field_74320_O == 0) {
            if (this.field_73839_d.field_71442_b.func_78747_a() && this.field_73839_d.field_147125_j == null) {
                RayTraceResult raytraceresult = this.field_73839_d.field_71476_x;
                if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
                    return;
                }
                BlockPos blockpos = raytraceresult.func_178782_a();
                IBlockState state = this.field_73839_d.field_71441_e.func_180495_p(blockpos);
                if (!state.func_177230_c().hasTileEntity(state) || !(this.field_73839_d.field_71441_e.func_175625_s(blockpos) instanceof IInventory)) {
                    return;
                }
            }
            int width = resolution.func_78326_a();
            int height = resolution.func_78328_b();
            if (gamesettings.field_74330_P && !gamesettings.field_74319_N && !this.field_73839_d.field_71439_g.func_175140_cp() && !gamesettings.field_178879_v) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)this.field_73735_i);
                Entity entity = this.field_73839_d.func_175606_aa();
                if (entity == null) {
                    return;
                }
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                OpenGlHelper.func_188785_m((int)10);
                GlStateManager.func_179121_F();
            } else {
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179141_d();
                this.func_73729_b(width / 2 - 7, height / 2 - 7, 0 + 16 * type, 0, 16, 16);
                if (this.field_73839_d.field_71474_y.field_186716_M == 1) {
                    this.field_73839_d.func_110434_K().func_110577_a(field_110324_m);
                    float f = this.field_73839_d.field_71439_g.func_184825_o(0.0f);
                    if (f < 1.0f) {
                        int i = height / 2 - 7 + 16;
                        int j = width / 2 - 7;
                        int k = (int)(f * 17.0f);
                        this.func_73729_b(j, i, 36, 94, 16, 4);
                        this.func_73729_b(j, i, 52, 94, k, 4);
                    }
                }
            }
        }
    }
}

