/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.gear;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IGearItem;
import net.silentchaos512.gems.compat.gear.SGearCompat;
import net.silentchaos512.gems.lib.EnumToolType;

public final class SGearProxy {
    private static boolean modLoaded = false;

    private SGearProxy() {
        throw new IllegalAccessError("Utility class");
    }

    public static void detectSilentGear() {
        modLoaded = Loader.isModLoaded((String)"silentgear");
        if (modLoaded) {
            SilentGems.logHelper.info("Detected Silent Gear!", new Object[0]);
        }
    }

    public static boolean isLoaded() {
        return modLoaded;
    }

    public static String getGradeString(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.getGradeString(stack);
        }
        return "N/A";
    }

    public static int getPartTier(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.getPartTier(stack);
        }
        return -1;
    }

    public static boolean isGearItem(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.isGearItem(stack);
        }
        return false;
    }

    public static boolean isMainPart(ItemStack stack) {
        if (modLoaded) {
            return SGearCompat.isMainPart(stack);
        }
        return false;
    }

    public static EnumToolType getSGemsTypeFromGearItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof IGearItem) {
            return ((IGearItem)stack.func_77973_b()).getToolType();
        }
        if (modLoaded) {
            return SGearCompat.getSGemsTypeFromGearItem(stack);
        }
        return EnumToolType.NONE;
    }

    public static void recalculateStats(ItemStack stack, @Nullable EntityPlayer player) {
        if (modLoaded) {
            SGearCompat.recalculateStats(stack, player);
        }
    }

    public static void addSoulPart(ItemStack stack) {
        if (modLoaded) {
            SGearCompat.addSoulPart(stack);
        }
    }
}

