/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.gear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gems.init.ModEnchantments;

public class SGearStatHandler {
    public static final ItemStat CHARGEABILITY = new ItemStat(new ResourceLocation("silentgems", "chargeability"), 1.0f, 0.0f, 100.0f, false, TextFormatting.GOLD).setSynergyApplies(false).setAffectedByGrades(false).setHidden(true);
    private static final Map<ItemStat, ToDoubleFunction<ChargedProperties>> BOOSTED_STATS = ImmutableMap.builder().put((Object)CommonItemStats.DURABILITY, prop -> (double)((ChargedProperties)prop).originalStat * Math.pow(2.0, ((ChargedProperties)prop).chargeValue)).put((Object)CommonItemStats.ARMOR_DURABILITY, prop -> (double)((ChargedProperties)prop).originalStat * Math.pow(1.8, ((ChargedProperties)prop).chargeValue)).put((Object)CommonItemStats.ENCHANTABILITY, prop -> (double)((ChargedProperties)prop).originalStat * (1.0 + (double)((ChargedProperties)prop).superchargedLevel * (Math.sqrt(((ChargedProperties)prop).chargeability) - 1.0))).put((Object)CommonItemStats.RARITY, prop -> ((ChargedProperties)prop).originalStat + (float)(((ChargedProperties)prop).superchargedLevel * 10)).put((Object)CommonItemStats.HARVEST_LEVEL, prop -> ((ChargedProperties)prop).originalStat + (float)((ChargedProperties)prop).superchargedLevel).put((Object)CommonItemStats.HARVEST_SPEED, prop -> ((ChargedProperties)prop).originalStat + (float)((ChargedProperties)prop).superchargedLevel * ((ChargedProperties)prop).chargeValue * 3.0f).put((Object)CommonItemStats.MELEE_DAMAGE, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue * 2.0f).put((Object)CommonItemStats.MAGIC_DAMAGE, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue * 2.0f).put((Object)CommonItemStats.RANGED_DAMAGE, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue).put((Object)CommonItemStats.ARMOR, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue).put((Object)CommonItemStats.ARMOR_TOUGHNESS, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue / 2.0f).put((Object)CommonItemStats.MAGIC_ARMOR, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue).build();

    @SubscribeEvent
    public void onGetPartStats(GetStatModifierEvent event) {
        ItemStack stack = event.getPart().getCraftingItem();
        int supercharged = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.supercharged, (ItemStack)stack);
        if (supercharged > 0 && BOOSTED_STATS.containsKey(event.getStat())) {
            float chargeability = CHARGEABILITY.compute(0.0f, event.getPart().getStatModifiers(CHARGEABILITY));
            if (chargeability == 0.0f) {
                chargeability = 1.0f;
            }
            float chargeLevel = chargeability * (float)supercharged;
            for (int i = 0; i < event.getModifiers().size(); ++i) {
                StatInstance instance = (StatInstance)event.getModifiers().get(i);
                if (instance.getOp() != StatInstance.Operation.AVG && instance.getOp() != StatInstance.Operation.MAX) continue;
                ChargedProperties chargedProperties = new ChargedProperties(supercharged, chargeLevel, instance.getValue());
                StatInstance replacement = new StatInstance(instance.getId() + "_supercharged_" + supercharged, (float)BOOSTED_STATS.get(event.getStat()).applyAsDouble(chargedProperties), instance.getOp());
                event.getModifiers().remove(instance);
                event.getModifiers().add(replacement);
            }
        }
    }

    private static class ChargedProperties {
        private final int superchargedLevel;
        private final float chargeValue;
        private final float chargeability;
        private final float originalStat;

        private ChargedProperties(int superchargedLevel, float chargeValue, float originalStat) {
            this.superchargedLevel = superchargedLevel;
            this.chargeValue = chargeValue;
            this.chargeability = this.chargeValue / (float)this.superchargedLevel;
            this.originalStat = originalStat;
        }
    }
}

