/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.config;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.ConfigOption;

public class ConfigOptionOreGen
extends ConfigOption {
    private static final float VEIN_COUNT_MIN = 0.0f;
    private static final float VEIN_COUNT_MAX = 1000.0f;
    private static final int VEIN_SIZE_MIN = 0;
    private static final int VEIN_SIZE_MAX = 1000;
    private static final int Y_MIN = 0;
    private static final int Y_MAX = 255;
    private final String name;
    private float veinCount;
    private int veinSize;
    private int minY;
    private int maxY;
    private final int dimension;
    private final Set<Integer> dimensionList = new HashSet<Integer>();
    private boolean dimensionListIsWhitelist = false;
    private final Set<Block> blockList = new HashSet<Block>();
    private Predicate<IBlockState> blockPredicate;

    public ConfigOptionOreGen(String name, int dimension, float veinCount, int veinSize, int minY, int maxY) {
        this.name = name;
        this.veinCount = veinCount;
        this.veinSize = veinSize;
        this.minY = minY;
        this.maxY = maxY;
        this.dimension = dimension;
    }

    public int getVeinCount(Random random) {
        float diff = this.veinCount - (float)((int)this.veinCount);
        return (int)this.veinCount + (random.nextFloat() < diff ? 1 : 0);
    }

    @Override
    public ConfigOption loadValue(Configuration c, String category) {
        return this.loadValue(c, category + "." + this.name, "World generation for " + this.name);
    }

    @Override
    public ConfigOption loadValue(Configuration c, String category, String comment) {
        int[] dimList;
        c.setCategoryComment(category, comment);
        this.veinCount = (float)c.get(category, "Vein Count", (double)this.veinCount).getDouble();
        this.veinSize = c.get(category, "Vein Size", this.veinSize).getInt();
        this.minY = c.get(category, "Min Y", this.minY).getInt();
        this.maxY = c.get(category, "Max Y", this.maxY).getInt();
        this.dimensionList.clear();
        for (int dim : dimList = c.get(category, "Dimension Blacklist", new int[0]).getIntList()) {
            this.dimensionList.add(dim);
        }
        this.dimensionListIsWhitelist = c.get(category, "Dimension List Is Whitelist", false).getBoolean();
        this.blockList.clear();
        String[] blocksDefault = new String[]{this.dimension == -1 ? "minecraft:netherrack" : (this.dimension == 1 ? "minecraft:end_stone" : "minecraft:stone")};
        String[] blocks = c.get(category, "Blocks To Replace", blocksDefault).getStringList();
        Arrays.stream(blocks).map(Block::func_149684_b).filter(Objects::nonNull).forEach(this.blockList::add);
        if (this.blockList.isEmpty()) {
            this.blockList.add(Blocks.field_150348_b);
        }
        this.blockPredicate = state -> state != null && this.blockList.contains(state.func_177230_c());
        return this.validate();
    }

    @Override
    public ConfigOption validate() {
        this.veinCount = MathHelper.func_76131_a((float)this.veinCount, (float)0.0f, (float)1000.0f);
        this.veinSize = MathHelper.func_76125_a((int)this.veinSize, (int)0, (int)1000);
        this.minY = MathHelper.func_76125_a((int)this.minY, (int)0, (int)255);
        this.maxY = MathHelper.func_76125_a((int)this.maxY, (int)0, (int)255);
        if (this.maxY <= this.minY) {
            SilentGems.logHelper.warn("Ore config \"" + this.name + "\": Min Y is greater than Max Y!", new Object[0]);
            this.maxY = this.minY + 1;
        }
        return this;
    }

    public boolean isEnabled() {
        return this.veinCount > 0.0f && this.veinSize > 0;
    }

    public BlockPos getRandomPos(Random random, int posX, int posZ) {
        return new BlockPos(posX + random.nextInt(16), this.minY + random.nextInt(this.maxY - this.minY), posZ + random.nextInt(16));
    }

    public boolean canSpawnInDimension(int dim) {
        return this.dimensionList.contains(dim) == this.dimensionListIsWhitelist;
    }

    public String getName() {
        return this.name;
    }

    public float getVeinCount() {
        return this.veinCount;
    }

    public int getVeinSize() {
        return this.veinSize;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isDimensionListIsWhitelist() {
        return this.dimensionListIsWhitelist;
    }

    public Set<Block> getBlockList() {
        return this.blockList;
    }

    public Predicate<IBlockState> getBlockPredicate() {
        return this.blockPredicate;
    }
}

