/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.lib.part.ToolPartGem;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.Color;

public class EntityChaosProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    static final double RENDER_DISTANCE_WEIGHT = 10.0;
    static final float SIZE = 1.0f;
    static final float SPEED_MULTI = 1.7f;
    static final String NBT_COLOR = "Color";
    static final String NBT_DAMAGE = "Damage";
    static final String NBT_GRAVITY = "Gravity";
    static final String NBT_SHOOTER = "Shooter";
    protected EntityLivingBase shooter;
    private Color color = Color.WHITE;
    protected float damage = 0.0f;
    protected double bounciness = 0.75;
    protected int bounces = 4;
    protected float gravity = 0.025f;

    public EntityChaosProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityChaosProjectile(EntityLivingBase shooter, ItemStack castingStack, float damage) {
        super(shooter.field_70170_p, shooter);
        this.shooter = shooter;
        this.damage = damage;
        this.func_70105_a(1.0f, 1.0f);
        this.setStartingVelocity(shooter, SilentGems.random);
        ToolPart part = ToolHelper.getRenderPart(castingStack, ToolPartPosition.HEAD);
        if (part instanceof ToolPartGem) {
            ToolPartGem partGem = (ToolPartGem)part;
            this.color = new Color(partGem.getGem().getColor());
        } else if (part != null) {
            this.color = new Color(part.getColor(castingStack, ToolPartPosition.HEAD, 0));
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
    }

    protected void setStartingVelocity(EntityLivingBase shooter, Random random) {
        Vec3d vec = shooter.func_70040_Z();
        this.field_70159_w = vec.field_72450_a;
        this.field_70181_x = vec.field_72448_b;
        this.field_70179_y = vec.field_72449_c;
        this.field_70159_w += shooter.field_70159_w;
        this.field_70181_x += shooter.field_70181_x;
        this.field_70179_y += shooter.field_70179_y;
        this.field_70159_w *= (double)1.7f;
        this.field_70181_x *= (double)1.7f;
        this.field_70179_y *= (double)1.7f;
    }

    public int getMaxLife() {
        return 200;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d vec1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult mop = this.field_70170_p.func_147447_a(vec1, vec2, false, true, false);
        if (mop != null) {
            this.func_70184_a(mop);
        }
        if (this.field_70173_aa > this.getMaxLife()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS_PROJECTILE_BODY, this.getColor(), this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            if (this.field_70173_aa > 2) {
                int i = 0;
                while (true) {
                    if (i >= 1 + 3 / (1 + 2 * SilentGems.proxy.getParticleSettings())) break;
                    double mx = this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f;
                    double my = this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f;
                    double mz = this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f;
                    SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS, this.getColor(), this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, mx, my, mz);
                    ++i;
                }
            }
        }
    }

    protected void func_70184_a(RayTraceResult mop) {
        BlockPos posHit = mop.func_178782_a();
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY && this.shooter != null && mop.field_72308_g != this.shooter) {
            this.onImpactWithEntity(mop);
        } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK && this.canCollideWithBlock(this.field_70170_p.func_180495_p(posHit), posHit)) {
            this.onImpactWithBlock(mop);
        }
    }

    public void onImpactWithEntity(RayTraceResult mop) {
        Entity e = mop.field_72308_g;
        e.func_70097_a(DamageSource.func_76354_b((Entity)this.getShooter(), (Entity)this.getShooter()), this.damage);
        this.func_70106_y();
    }

    public void onImpactWithBlock(RayTraceResult mop) {
        BlockPos pos = mop.func_178782_a();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        AxisAlignedBB boundingBox = state.func_185900_c((IBlockAccess)this.field_70170_p, pos);
        if (this.bounces > 0 && boundingBox != null) {
            --this.bounces;
            switch (mop.field_178784_b) {
                case UP: 
                case DOWN: {
                    this.field_70181_x *= -this.bounciness;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.field_70179_y *= -this.bounciness;
                    break;
                }
                case EAST: 
                case WEST: {
                    this.field_70159_w *= -this.bounciness;
                }
            }
            this.spawnHitParticles(16);
            this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187835_fT, SoundCategory.AMBIENT, 0.5f, 0.65f);
        } else if (boundingBox != null) {
            this.func_70106_y();
        }
    }

    protected boolean canCollideWithBlock(IBlockState state, BlockPos pos) {
        Material mat = state.func_185904_a();
        if (mat == Material.field_151579_a || mat == Material.field_151585_k || mat == Material.field_151582_l) {
            return false;
        }
        return state.func_185900_c((IBlockAccess)this.field_70170_p, pos) != null;
    }

    public float func_70185_h() {
        return this.gravity;
    }

    public void func_70106_y() {
        this.spawnHitParticles(64);
        float f = (float)(0.75 + this.field_70146_Z.nextGaussian() * (double)0.05f);
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187619_bk, SoundCategory.AMBIENT, 0.75f, f);
        super.func_70106_y();
    }

    protected void spawnHitParticles(int count) {
        for (int i = 0; i < count; ++i) {
            double mX = this.field_70146_Z.nextGaussian() * 0.05;
            double mY = this.field_70146_Z.nextGaussian() * 0.05;
            double mZ = this.field_70146_Z.nextGaussian() * 0.05;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, mX, mY, mZ, new int[0]);
        }
    }

    protected void func_70044_A() {
    }

    public void func_181015_d(BlockPos pos) {
    }

    public Color getColor() {
        return this.color;
    }

    public EntityChaosProjectile setColor(Color color) {
        this.color = color;
        return this;
    }

    public EntityChaosProjectile setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public EntityLivingBase getShooter() {
        return this.shooter;
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.setColor(new Color(tags.func_74762_e(NBT_COLOR)));
        this.damage = tags.func_74760_g(NBT_DAMAGE);
        this.gravity = tags.func_74760_g(NBT_GRAVITY);
        if (tags.func_74764_b(NBT_SHOOTER)) {
            this.shooter = this.field_70170_p.func_72924_a(tags.func_74779_i(NBT_SHOOTER));
            if (this.shooter == null) {
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74768_a(NBT_COLOR, this.color.getColor());
        tags.func_74776_a(NBT_DAMAGE, this.damage);
        tags.func_74776_a(NBT_GRAVITY, this.gravity);
        if (this.shooter != null) {
            tags.func_74778_a(NBT_SHOOTER, this.shooter.func_70005_c_());
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.color = new Color(data.readInt());
            this.damage = data.readFloat();
            this.gravity = data.readFloat();
            byte[] bytes = new byte[data.readableBytes()];
            data.readBytes(bytes);
            String shooterName = new String(bytes);
            this.shooter = this.field_70170_p.func_72924_a(shooterName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.color.getColor());
        data.writeFloat(this.damage);
        data.writeFloat(this.gravity);
        ByteBufUtil.writeUtf8((ByteBuf)data, (CharSequence)this.shooter.func_70005_c_());
    }
}

