/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.event;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.Skulls;
import net.silentchaos512.gems.entity.EntityChaosProjectile;
import net.silentchaos512.gems.entity.EntityChaosProjectileScatter;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.init.ModSounds;
import net.silentchaos512.gems.item.ItemBlockPlacer;
import net.silentchaos512.gems.item.ItemSoulGem;
import net.silentchaos512.gems.lib.Greetings;
import net.silentchaos512.gems.lib.module.ModuleCoffee;
import net.silentchaos512.gems.lib.module.ModuleEntityRandomEquipment;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.loot.LootHandler;
import net.silentchaos512.gems.skills.ToolSkill;
import net.silentchaos512.gems.skills.ToolSkillDigger;
import net.silentchaos512.gems.util.ArmorHelper;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.GameUtil;
import net.silentchaos512.lib.util.PlayerHelper;

public class GemsCommonEvents {
    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Greetings.greetPlayer(event.player);
        SilentGems.logHelper.info("Recalculating tool and armor stats for " + event.player.getDisplayNameString(), new Object[0]);
        for (ItemStack stack : PlayerHelper.getNonEmptyStacks((EntityPlayer)event.player)) {
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ITool) {
                ToolHelper.recalculateStats(stack);
            }
            if (!(stack.func_77973_b() instanceof IArmor)) continue;
            ArmorHelper.recalculateStats(stack);
        }
        if (GameUtil.isDeobfuscated()) {
            ModSounds.playAllHotswapFix(event.player);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() instanceof ITool || event.crafting.func_77973_b() instanceof IArmor) {
            ToolHelper.setOriginalOwner(event.crafting, event.player);
            ModItems.toolRenderHelper.updateModelCache(event.crafting);
        } else if (event.crafting.func_77973_b() == ModItems.chaosOrb) {
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack = event.craftMatrix.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != ModItems.chaosOrb) continue;
                int oldCharge = ModItems.chaosOrb.getCharge(stack);
                ModItems.chaosOrb.receiveCharge(event.crafting, oldCharge, false);
            }
        }
    }

    @SubscribeEvent
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!mainHand.func_190926_b()) {
            ToolSkill skill;
            int gravityLevel;
            if (event.getState().func_177230_c() == ModBlocks.fluffyBlock) {
                ModBlocks.fluffyBlock.onGetBreakSpeed(event);
            }
            if ((gravityLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.gravity, (ItemStack)mainHand)) > 0) {
                ModEnchantments.gravity.onGetBreakSpeed(event, mainHand, gravityLevel);
            }
            if ((skill = ToolHelper.getSuperSkill(mainHand)) instanceof ToolSkillDigger && ToolHelper.isSpecialAbilityEnabled(mainHand)) {
                ((ToolSkillDigger)skill).onGetBreakSpeed(event);
            }
        }
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        LootHandler.init(event);
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            int lifeStealLevel = 0;
            int iceAspectLevel = 0;
            int lightningAspectLevel = 0;
            if (!mainHand.func_190926_b()) {
                lifeStealLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.lifeSteal, (ItemStack)mainHand);
                iceAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.iceAspect, (ItemStack)mainHand);
                lightningAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.lightningAspect, (ItemStack)mainHand);
            }
            if (lifeStealLevel < 1 && !offHand.func_190926_b()) {
                lifeStealLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.lifeSteal, (ItemStack)offHand);
            }
            if (lifeStealLevel > 0) {
                float amount = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
                float healAmount = ModEnchantments.lifeSteal.getAmountHealed(lifeStealLevel, amount);
                player.func_70691_i(healAmount);
            }
            if (iceAspectLevel > 0) {
                ModEnchantments.iceAspect.applyTo(event.getEntityLiving(), iceAspectLevel);
            }
            if (lightningAspectLevel > 0) {
                ModEnchantments.lightningAspect.applyTo(event.getEntityLiving(), lightningAspectLevel);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ItemStack weapon;
        EntityChaosProjectile projectile;
        EntityLivingBase shooter;
        Entity entitySource = event.getSource().func_76346_g();
        EntityPlayer player = null;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer deadPlayer = (EntityPlayer)event.getEntityLiving();
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(deadPlayer);
            data.haloTime = 12000;
        }
        if (entitySource instanceof EntityPlayer) {
            player = (EntityPlayer)entitySource;
        } else if (entitySource instanceof EntityChaosProjectile && (shooter = (projectile = (EntityChaosProjectile)entitySource).getShooter()) instanceof EntityPlayer) {
            player = (EntityPlayer)shooter;
        }
        if (player != null && !(weapon = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && weapon.func_77973_b() instanceof ITool) {
            ToolHelper.incrementStatKillCount(weapon, 1);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityRabbit) {
            EntityRabbit rabbit = (EntityRabbit)event.getEntityLiving();
            ModuleCoffee.tickRabbit(rabbit);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityPlayer) {
            ToolSoul toolSoul;
            ItemStack soulGem;
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack weapon = player.func_184614_ca();
            EntityLivingBase killed = event.getEntityLiving();
            ItemSoulGem.Soul soul = ModItems.soulGem.getSoul(killed.getClass());
            if (soul != null && SilentGems.random.nextFloat() < soul.getDropRate() && !(soulGem = ModItems.soulGem.getStack(soul)).func_190926_b()) {
                EntityItem entityItem = new EntityItem(killed.field_70170_p, killed.field_70165_t, killed.field_70163_u + (double)(killed.field_70131_O / 2.0f), killed.field_70161_v, soulGem);
                event.getDrops().add(entityItem);
            }
            if ((toolSoul = SoulManager.getSoul(weapon)) != null && toolSoul.hasSkill(SoulSkill.HEAD_BONUS)) {
                ItemStack skull;
                int level = toolSoul.getSkillLevel(SoulSkill.HEAD_BONUS);
                float rate = Skulls.getDropRate(killed);
                if (SilentGems.random.nextFloat() < 1.5f * (float)level * rate && !(skull = Skulls.getSkull(killed)).func_190926_b()) {
                    EntityItem entityItem = new EntityItem(killed.field_70170_p, killed.field_70165_t, killed.field_70163_u + (double)(killed.field_70131_O / 2.0f), killed.field_70161_v, skull);
                    event.getDrops().add(entityItem);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        boolean isMature;
        ItemSoulGem.Soul soul = ModItems.soulGem.getSoul(event);
        Block block = event.getState().func_177230_c();
        boolean isCrop = block instanceof BlockCrops;
        boolean bl = isMature = isCrop && ((BlockCrops)block).func_185525_y(event.getState());
        if (soul != null && (!isCrop || isCrop && isMature)) {
            float dropRate = soul.getDropRate() * (1.0f + 0.15f * (float)event.getFortuneLevel());
            if (SilentGems.random.nextFloat() < dropRate) {
                event.getDrops().add(soul.getStack());
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase) {
            ModuleEntityRandomEquipment.tryGiveMobEquipment((EntityLivingBase)entity);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack entityStack = event.getItem().func_92059_d();
        if (entityStack.func_77973_b() instanceof ItemBlock) {
            for (ItemStack stack : PlayerHelper.getNonEmptyStacks((EntityPlayer)event.getEntityPlayer())) {
                int amountAbsorbed;
                IBlockState state;
                ItemBlockPlacer itemPlacer;
                if (!(stack.func_77973_b() instanceof ItemBlockPlacer) || !(itemPlacer = (ItemBlockPlacer)stack.func_77973_b()).getAutoFillMode(stack) || !(state = ((ItemBlock)entityStack.func_77973_b()).func_179223_d().func_176203_a(entityStack.func_77952_i())).equals(itemPlacer.getBlockPlaced(stack)) || (amountAbsorbed = itemPlacer.absorbBlocks(stack, entityStack)) <= 0) continue;
                entityStack.func_190918_g(amountAbsorbed);
                if (entityStack.func_190916_E() <= 0) {
                    event.getItem().func_70106_y();
                }
                event.getEntityPlayer().field_70170_p.func_184133_a(null, event.getItem().func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (SilentGems.random.nextFloat() - SilentGems.random.nextFloat()) * 1.4f + 2.0f);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityChaosProjectileScatter.DamageQueue.processDamage();
        }
    }
}

