/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.event;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerTickHandler {
    public static final ServerTickHandler INSTANCE = new ServerTickHandler();
    private static final Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();

    private ServerTickHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void schedule(Runnable runnable) {
        scheduledActions.add(runnable);
    }

    @SubscribeEvent
    public void serverTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        while (!scheduledActions.isEmpty()) {
            scheduledActions.poll().run();
        }
    }
}

