/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IBlockPlacer;
import net.silentchaos512.gems.util.NBTHelper;
import net.silentchaos512.lib.item.ILeftClickItem;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.PlayerHelper;

public abstract class ItemBlockPlacer
extends Item
implements IBlockPlacer,
ILeftClickItem,
IAddRecipes {
    private static final int ABSORB_DELAY = 20;
    private static final String NBT_AUTO_FILL = "AutoFill";
    private static final String NBT_BLOCK_COUNT = "BlockCount";
    private int maxBlocks;

    ItemBlockPlacer(int maxBlocks) {
        this.maxBlocks = maxBlocks;
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        boolean autoFillOn = this.getAutoFillMode(stack);
        int currentBlocks = this.getRemainingBlocks(stack);
        int maxBlocks = this.getMaxBlocksStored(stack);
        list.add(SilentGems.i18n.subText("blockplacer", "item", "count", new Object[]{currentBlocks, maxBlocks}));
        String onOrOff = SilentGems.i18n.miscText("state." + (autoFillOn ? "on" : "off"), new Object[0]);
        list.add(SilentGems.i18n.subText("blockplacer", "item", "autoFill", new Object[]{onOrOff}));
    }

    @Override
    @Nullable
    public abstract IBlockState getBlockPlaced(ItemStack var1);

    public int getBlockMetaDropped(ItemStack stack) {
        IBlockState state = this.getBlockPlaced(stack);
        return state.func_177230_c().func_176201_c(state);
    }

    @Override
    public int getRemainingBlocks(ItemStack stack) {
        return NBTHelper.getTagInt(stack, NBT_BLOCK_COUNT);
    }

    @Override
    public void setRemainingBlocks(ItemStack stack, int value) {
        value = MathHelper.func_76125_a((int)value, (int)0, (int)this.getMaxBlocksStored(stack));
        NBTHelper.setTagInt(stack, NBT_BLOCK_COUNT, value);
    }

    @Override
    public int getMaxBlocksStored(ItemStack stack) {
        return this.maxBlocks;
    }

    public boolean getAutoFillMode(ItemStack stack) {
        if (!NBTHelper.hasKey(stack, NBT_AUTO_FILL)) {
            NBTHelper.setTagBoolean(stack, NBT_AUTO_FILL, true);
        }
        return NBTHelper.getTagBoolean(stack, NBT_AUTO_FILL);
    }

    public void setAutoFillMode(ItemStack stack, boolean value) {
        NBTHelper.setTagBoolean(stack, NBT_AUTO_FILL, value);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L && entity instanceof EntityPlayer && this.getAutoFillMode(stack)) {
            this.absorbBlocksFromPlayer(stack, (EntityPlayer)entity);
        }
        if (stack.func_77952_i() > 0 && !NBTHelper.hasKey(stack, NBT_BLOCK_COUNT)) {
            int blockCount = this.getMaxBlocksStored(stack) - stack.func_77952_i();
            NBTHelper.setTagInt(stack, NBT_BLOCK_COUNT, blockCount);
            stack.func_77964_b(0);
        }
    }

    private ItemStack absorbBlocksFromPlayer(ItemStack stack, EntityPlayer player) {
        int maxBlocksStored = this.getMaxBlocksStored(stack);
        if (this.getRemainingBlocks(stack) >= maxBlocksStored) {
            return stack;
        }
        IBlockState statePlaced = this.getBlockPlaced(stack);
        if (statePlaced == null) {
            return stack;
        }
        Block blockPlaced = statePlaced.func_177230_c();
        int metaDropped = this.getBlockMetaDropped(stack);
        Item itemBlock = Item.func_150898_a((Block)blockPlaced);
        for (ItemStack invStack : PlayerHelper.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (invStack.func_77973_b() != itemBlock || invStack.func_77952_i() != metaDropped) continue;
            int currentBlocks = this.getRemainingBlocks(stack);
            if (currentBlocks + invStack.func_190916_E() > maxBlocksStored) {
                this.setRemainingBlocks(stack, this.maxBlocks);
                invStack.func_190918_g(maxBlocksStored - currentBlocks);
                return stack;
            }
            this.setRemainingBlocks(stack, currentBlocks + invStack.func_190916_E());
            invStack.func_190920_e(0);
            if (invStack.func_190916_E() > 0) continue;
            PlayerHelper.removeItem((EntityPlayer)player, (ItemStack)invStack);
        }
        return stack;
    }

    public int absorbBlocks(ItemStack placer, ItemStack blockStack) {
        int maxBlocksStored;
        int blockCount;
        int placerCount = this.getRemainingBlocks(placer);
        if (placerCount + (blockCount = blockStack.func_190916_E()) > (maxBlocksStored = this.getMaxBlocksStored(placer))) {
            this.setRemainingBlocks(placer, maxBlocksStored);
            return maxBlocksStored - placerCount;
        }
        this.setRemainingBlocks(placer, placerCount + blockCount);
        return blockCount;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af()) {
            boolean mode = !this.getAutoFillMode(stack);
            this.setAutoFillMode(stack, mode);
            String onOrOff = SilentGems.i18n.miscText("state." + (mode ? "on" : "off"), new Object[0]);
            onOrOff = (mode ? TextFormatting.GREEN : TextFormatting.RED) + onOrOff;
            String line = SilentGems.i18n.subText("blockplacer", "item", "autoFill", new Object[]{onOrOff});
            ChatHelper.sendStatusMessage((EntityPlayer)player, (String)line, (boolean)true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getRemainingBlocks(stack) <= 0 && !player.field_71075_bZ.field_75098_d) {
            return EnumActionResult.PASS;
        }
        IBlockState state = this.getBlockPlaced(stack);
        if (state == null) {
            return EnumActionResult.PASS;
        }
        Block block = state.func_177230_c();
        ItemStack fakeBlockStack = new ItemStack(block, 1, block.func_176201_c(state));
        ItemStack currentOffhand = player.func_184592_cb();
        player.func_184611_a(EnumHand.OFF_HAND, fakeBlockStack);
        EnumActionResult result = ItemHelper.onItemUse((Item)fakeBlockStack.func_77973_b(), (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)EnumHand.OFF_HAND, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ);
        player.func_184611_a(EnumHand.OFF_HAND, currentOffhand);
        if (result == EnumActionResult.SUCCESS) {
            this.setRemainingBlocks(stack, this.getRemainingBlocks(stack) - 1);
        }
        return result;
    }

    public ActionResult<ItemStack> onItemLeftClickSL(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af() && this.getRemainingBlocks(stack) > 0) {
            IBlockState state = this.getBlockPlaced(stack);
            int meta = this.getBlockMetaDropped(stack);
            ItemStack toDrop = new ItemStack(state.func_177230_c(), 1, meta);
            toDrop.func_190920_e(Math.min(this.getRemainingBlocks(stack), toDrop.func_77976_d()));
            this.setRemainingBlocks(stack, this.getRemainingBlocks(stack) - toDrop.func_190916_E());
            Vec3d vec = player.func_70040_Z().func_186678_a(2.0);
            EntityItem entity = new EntityItem(world, player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.0 + vec.field_72448_b, player.field_70161_v + vec.field_72450_a, toDrop);
            vec = vec.func_186678_a(-0.125);
            entity.field_70159_w = vec.field_72450_a;
            entity.field_70181_x = vec.field_72448_b;
            entity.field_70179_y = vec.field_72449_c;
            EntityHelper.safeSpawn((Entity)entity);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack stackEmpty = new ItemStack((Item)this);
        ItemStack stackFull = new ItemStack((Item)this);
        this.setRemainingBlocks(stackFull, this.getMaxBlocksStored(stackFull));
        list.add((Object)stackEmpty);
        list.add((Object)stackFull);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int maxBlocksStored = this.getMaxBlocksStored(stack);
        if (maxBlocksStored <= 0) {
            return 1.0;
        }
        return 1.0 - (double)this.getRemainingBlocks(stack) / (double)maxBlocksStored;
    }
}

