/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.MathUtils;

public class ItemFoodSG
extends ItemFood
implements IAddRecipes,
ICustomModel {
    private static final String[] NAMES = new String[]{"potatostick", "sugarcookie", "secretdonut", "meatystewuncooked", "meatystew", "candycane", "coffeecup"};
    private static final int[] foodLevel = new int[]{8, 2, 6, 4, 12, 2, 1};
    private static final float[] saturationLevel = new float[]{0.8f, 0.4f, 0.8f, 0.6f, 1.6f, 0.2f, 0.2f};
    private static final boolean[] alwaysEdible = new boolean[]{false, true, false, false, false, true, true};
    public final ItemStack potatoStick = this.getStack("potatostick");
    public final ItemStack sugarCookie = this.getStack("sugarcookie");
    public final ItemStack secretDonut = this.getStack("secretdonut");
    public final ItemStack meatyStewUncooked = this.getStack("meatystewuncooked");
    public final ItemStack meatyStew = this.getStack("meatystew");
    public final ItemStack candyCane = this.getStack("candycane");
    public final ItemStack coffeeCup = this.getStack("coffeecup");
    public static final List<SecretDonutEffect> secretDonutEffects = Lists.newArrayList();

    public ItemFoodSG() {
        super(1, 0.1f, false);
        secretDonutEffects.clear();
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76440_q, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76431_k, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76420_g, 1.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76419_f, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76422_e, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76426_n, 4.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76438_s, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76441_p, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76430_j, 1.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76421_d, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76424_c, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76439_r, 1.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76436_u, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76428_l, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76429_m, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76427_o, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76437_t, 1.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_82731_v, 0.5f));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int meta = stack.func_77952_i();
        if (meta < NAMES.length) {
            list.add(TextFormatting.ITALIC + SilentGems.i18n.itemSubText(NAMES[meta], "desc", new Object[0]));
        }
    }

    private void addSecretDonutEffect(World world, EntityPlayer player) {
        SecretDonutEffect effect = secretDonutEffects.get(world.field_73012_v.nextInt(secretDonutEffects.size()));
        player.func_70690_d(new PotionEffect(effect.potion, (int)((float)GemsConfig.FOOD_SUPPORT_DURATION * effect.durationMulti), 0, true, false));
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77952_i() == this.sugarCookie.func_77952_i()) {
            return 16;
        }
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77952_i() == this.coffeeCup.func_77952_i()) {
            return EnumAction.DRINK;
        }
        return super.func_77661_b(stack);
    }

    public ItemStack getStack(String name) {
        return this.getStack(name, 1);
    }

    public ItemStack getStack(String name, int count) {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equals(name)) continue;
            return new ItemStack((Item)this, count, i);
        }
        return ItemStack.field_190927_a;
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() < NAMES.length) {
            return "item.silentgems." + NAMES[stack.func_77952_i()];
        }
        return super.func_77667_c(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_71043_e(alwaysEdible[stack.func_77952_i()])) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int d = stack.func_77952_i();
            if (d == 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, GemsConfig.FOOD_SUPPORT_DURATION, 0, true, false));
                this.givePlayerItem(player, new ItemStack(Items.field_151055_y));
            } else if (d == 1) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, GemsConfig.FOOD_SUPPORT_DURATION, 0, true, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, GemsConfig.FOOD_SUPPORT_DURATION, 0, true, false));
            } else if (d == 2) {
                this.onDonutEaten(world, player);
            } else if (d == 3 || d == 4) {
                this.givePlayerItem(player, new ItemStack(Items.field_151054_z));
            } else if (d == 5) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, GemsConfig.FOOD_SUPPORT_DURATION / 6, 0, true, false));
            } else if (d == 6) {
                int duration = (int)(2.0f * (float)GemsConfig.FOOD_SUPPORT_DURATION);
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 2, 1, true, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration, 1, true, false));
            }
        }
        super.func_77849_c(stack, world, player);
    }

    private void onDonutEaten(World world, EntityPlayer player) {
        if (SilentGems.random.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_CHANCE) {
            this.addSecretDonutEffect(world, player);
            if (SilentGems.random.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_CHANCE) {
                this.addSecretDonutEffect(world, player);
                if (SilentGems.random.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_CHANCE) {
                    this.addSecretDonutEffect(world, player);
                }
            }
        }
        if (SilentGems.random.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_TEXT_CHANCE) {
            int index = MathUtils.nextIntInclusive((int)1, (int)8);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("donut.silentgems." + index, new Object[0]));
        }
    }

    private void givePlayerItem(EntityPlayer player, ItemStack stack) {
        EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, stack);
        player.field_70170_p.func_72838_d((Entity)item);
    }

    public int func_150905_g(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta < 0 || meta >= NAMES.length) {
            return 0;
        }
        return foodLevel[meta];
    }

    public float func_150906_h(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta < 0 || meta >= NAMES.length) {
            return 0.0f;
        }
        return saturationLevel[meta];
    }

    public boolean func_77845_h() {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (String name : NAMES) {
            items.add((Object)this.getStack(name));
        }
    }

    public void addRecipes(RecipeMaker recipes) {
        recipes.addSmelting(this.getStack("meatystewuncooked", 1), this.getStack("meatystew", 1), 0.5f);
    }

    public void registerModels() {
        for (int i = 0; i < NAMES.length; ++i) {
            SilentGems.registry.setModel((Item)this, i, NAMES[i]);
        }
    }

    public static class SecretDonutEffect {
        public Potion potion;
        public float durationMulti;

        public SecretDonutEffect(Potion potion, float durationMulti) {
            this.potion = potion;
            this.durationMulti = durationMulti;
        }
    }
}

