/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.ItemBlockPlacer;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.registry.RecipeMaker;

public class ItemHoldingGem
extends ItemBlockPlacer {
    public static final String NBT_BLOCK_PLACED = "sg_block_placed";
    public static final String NBT_GEM_ID = "sg_gem_id";

    public ItemHoldingGem() {
        super(4096);
    }

    @Override
    public IBlockState getBlockPlaced(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_BLOCK_PLACED)) {
            return null;
        }
        int stateId = stack.func_77978_p().func_74762_e(NBT_BLOCK_PLACED);
        return Block.func_176220_d((int)stateId);
    }

    public void setBlockPlaced(ItemStack stack, IBlockState state) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_BLOCK_PLACED, Block.func_176210_f((IBlockState)state));
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        IBlockState state = this.getBlockPlaced(stack);
        if (state == null) {
            list.add(TextFormatting.ITALIC + SilentGems.i18n.subText((IForgeRegistryEntry)this, "desc", new Object[0]));
            return;
        }
        Block block = state.func_177230_c();
        ItemStack placedStack = new ItemStack(Item.func_150898_a((Block)block), 1, block.func_176201_c(state));
        list.add(placedStack.func_82833_r());
        super.func_77624_a(stack, world, list, flag);
    }

    public void addRecipes(RecipeMaker recipes) {
        for (EnumGem gem : EnumGem.values()) {
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74777_a(NBT_GEM_ID, (short)gem.ordinal());
            recipes.addShapedOre("holding_gem_" + gem.name(), stack, new Object[]{"gcg", "s s", "gcg", Character.valueOf('g'), "ingotGold", Character.valueOf('c'), CraftingItems.ENRICHED_CHAOS_ESSENCE.getStack(), Character.valueOf('s'), gem.getItemOreName()});
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (EnumGem gem : EnumGem.values()) {
            list.add((Object)this.construct(gem));
        }
    }

    public ItemStack construct(EnumGem gem) {
        ItemStack stack = new ItemStack((Item)this);
        this.setRemainingBlocks(stack, 0);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74777_a(NBT_GEM_ID, (short)gem.ordinal());
        return stack;
    }
}

