/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.quiver;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.silentchaos512.gems.init.ModItems;

public interface IQuiver {
    public static final int MAX_STACKS = 4;
    public static final String NBT_INVENTORY = "inventory";

    default public IItemHandler getInventory(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(NBT_INVENTORY)) {
            stack.func_77978_p().func_74782_a(NBT_INVENTORY, (NBTBase)new NBTTagList());
        }
        ItemStackHandler stackHandler = new ItemStackHandler(4);
        NBTTagList tagList = stack.func_77978_p().func_150295_c(NBT_INVENTORY, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            stackHandler.setStackInSlot(i, new ItemStack(tagList.func_150305_b(i)));
        }
        return stackHandler;
    }

    default public ItemStack updateQuiver(@Nonnull ItemStack stack, IItemHandler itemHandler, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        boolean containsArrows = false;
        if (itemHandler != null) {
            IQuiver intendedItem;
            NBTTagList invTag = new NBTTagList();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack arrowStack = itemHandler.getStackInSlot(i);
                invTag.func_74742_a((NBTBase)arrowStack.serializeNBT());
                containsArrows |= !arrowStack.func_190926_b();
            }
            stack.func_77978_p().func_74782_a(NBT_INVENTORY, (NBTBase)invTag);
            IQuiver iQuiver = intendedItem = containsArrows ? ModItems.quiver : ModItems.quiverEmpty;
            if (stack.func_77973_b() != intendedItem) {
                ItemStack newQuiver = new ItemStack((Item)intendedItem, 1);
                newQuiver.func_77982_d(stack.func_77978_p());
                int oldIndex = -1;
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack itemstack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (itemstack.func_190926_b() || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)itemstack)) continue;
                    oldIndex = i;
                    break;
                }
                if (oldIndex >= 0) {
                    player.field_71071_by.func_70299_a(oldIndex, newQuiver);
                }
            }
        }
        return stack;
    }
}

