/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.quiver;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.gui.GuiTypes;
import net.silentchaos512.gems.item.quiver.IQuiver;

public class QuiverHelper {
    public static final QuiverHelper instance = new QuiverHelper();
    private List<EntityArrow> firedArrows = new ArrayList<EntityArrow>();

    void addFiredArrow(EntityArrow arrow) {
        this.firedArrows.add(arrow);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        for (EntityArrow arrow : this.firedArrows) {
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
        this.firedArrows.removeIf(a -> true);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IQuiver)) {
            return;
        }
        IItemHandler itemHandler = ((IQuiver)stack.func_77973_b()).getInventory(stack);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack arrow = itemHandler.getStackInSlot(i);
            if (arrow.func_190926_b()) continue;
            tooltip.add(SilentGems.i18n.itemSubText("quiver", "arrowFormat", new Object[]{arrow.func_190916_E(), arrow.func_82833_r()}));
        }
    }

    public static ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187546_ae, SoundCategory.NEUTRAL, 0.8f, 0.8f, false);
        GuiTypes.QUIVER.open(player, world, hand == EnumHand.OFF_HAND ? 1 : 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }
}

