/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;

public class ItemGemShovel
extends ItemSpade
implements ITool,
IAddRecipes,
ICustomModel {
    public static final Set<Material> BASE_EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151571_B, (Object)Material.field_151596_z, (Object)Material.field_151577_b, (Object)Material.field_151578_c, (Object)Material.field_151595_p, (Object)Material.field_151597_y, (Object[])new Material[0]);

    public ItemGemShovel() {
        super(ToolHelper.FAKE_MATERIAL);
        this.setNoRepair();
    }

    public ItemStack constructTool(boolean supercharged, ItemStack material) {
        return this.constructTool(supercharged, material, material, material);
    }

    public ItemStack constructTool(boolean supercharged, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return ItemStack.field_190927_a;
        }
        ItemStack rod = supercharged ? CraftingItems.ORNATE_GOLD_ROD.getStack() : new ItemStack(Items.field_151055_y);
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.shovel;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return ItemStack.field_190927_a;
        }
        if (materials.length == 1) {
            return ToolHelper.constructTool((Item)this, rod, materials[0], materials[0], materials[0]);
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamageModifier() {
        return 1.5f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -3.0f;
    }

    @Override
    public float getRepairMultiplier() {
        return 2.0f;
    }

    @Override
    public boolean isDiggingTool() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        boolean broken = ToolHelper.isBroken(stack);
        if (!broken && ItemHelper.onItemUse((Item)Items.field_151047_v, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)hand, (EnumFacing)side, (float)hitX, (float)hitY, (float)hitZ) != EnumActionResult.SUCCESS) {
            return ToolHelper.onItemUse(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        if (!broken) {
            ToolHelper.incrementStatPathsMade(stack, 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean canceled = super.onBlockStartBreak(stack, pos, player);
        if (!canceled) {
            ToolHelper.onBlockStartBreak(stack, pos, player);
        }
        return canceled;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ToolHelper.getItemEnchantability(stack);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return ToolHelper.getDigSpeed(stack, state, null);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return ToolHelper.onBlockDestroyed(stack, world, state, pos, entityLiving);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState state) {
        if (super.getHarvestLevel(stack, toolClass, player, state) < 0 || ToolHelper.isBroken(stack)) {
            return -1;
        }
        return ToolHelper.getHarvestLevel(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ToolHelper.getAttributeModifiers(slot, stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        return ToolHelper.hitEntity(stack, entity1, entity2);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return ToolHelper.getIsRepairable(stack1, stack2);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack tool) {
        return this.canHarvestBlock(state, ToolHelper.getHarvestLevel(tool));
    }

    public boolean func_150897_b(IBlockState state) {
        return this.canHarvestBlock(state, 10);
    }

    private boolean canHarvestBlock(IBlockState state, int toolLevel) {
        if (state.func_177230_c().getHarvestLevel(state) > toolLevel) {
            return false;
        }
        if (BASE_EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return true;
        }
        return super.func_150897_b(state);
    }

    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, "h", "r", "r");
        }
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().func_77624_a(stack, world, list, flag);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems((Item)this, 1));
    }

    public void registerModels() {
        SilentGems.registry.setModel((Item)this, 0, "tool");
    }
}

