/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.client.gui.GuiChaosBar;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.entity.EntityChaosProjectile;
import net.silentchaos512.gems.entity.EntityChaosProjectileHoming;
import net.silentchaos512.gems.entity.EntityChaosProjectileScatter;
import net.silentchaos512.gems.entity.EntityChaosProjectileSweep;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.item.tool.ItemGemDagger;
import net.silentchaos512.gems.item.tool.ItemGemKatana;
import net.silentchaos512.gems.item.tool.ItemGemMachete;
import net.silentchaos512.gems.item.tool.ItemGemScepter;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.EnumMagicType;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.item.ILeftClickItem;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.EntityHelper;

public class ItemGemSword
extends ItemSword
implements ITool,
ILeftClickItem,
IAddRecipes,
ICustomModel {
    public ItemGemSword() {
        super(ToolHelper.FAKE_MATERIAL);
        this.setNoRepair();
    }

    public ItemStack constructTool(boolean supercharged, ItemStack material) {
        return this.constructTool(supercharged, material, material, material);
    }

    public ItemStack constructTool(boolean supercharged, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return ItemStack.field_190927_a;
        }
        ItemStack rod = supercharged ? CraftingItems.ORNATE_GOLD_ROD.getStack() : new ItemStack(Items.field_151055_y);
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.sword;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return ItemStack.field_190927_a;
        }
        if (materials.length == 2) {
            ItemStack temp = materials[0];
            materials[0] = materials[1];
            materials[1] = temp;
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamageModifier() {
        return 3.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 2.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -2.4f;
    }

    public ActionResult<ItemStack> onItemLeftClickSL(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af() || ToolHelper.getToolTier(stack).ordinal() < EnumMaterialTier.SUPER.ordinal()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (world.field_72995_K) {
            GuiChaosBar.INSTANCE.show();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        int costToCast = this.getShotCost(player, stack);
        int cooldown = this.getShotCooldown(player, stack);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        if (data.chaos >= costToCast && data.magicCooldown <= 0) {
            if (!player.field_71075_bZ.field_75098_d) {
                data.drainChaos(costToCast);
                data.magicCooldown = cooldown;
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            ToolHelper.incrementStatShotsFired(stack, 1);
            for (EntityChaosProjectile shot : this.getShots(player, stack)) {
                EntityHelper.safeSpawn((Entity)shot);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private List<EntityChaosProjectile> getShots(EntityPlayer player, ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        if (ToolHelper.getToolTier(stack).ordinal() < EnumMaterialTier.SUPER.ordinal()) {
            return list;
        }
        EnumMagicType magicType = EnumMagicType.getMagicType(stack);
        int shotCount = magicType.getShotCount(stack);
        float damage = 1.0f + this.getMagicDamage(stack);
        int magicEnchLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.magicDamage, (ItemStack)stack);
        if (magicEnchLevel > 0) {
            damage += ModEnchantments.magicDamage.calcDamage(magicEnchLevel);
        }
        damage *= magicType.getDamagePerShotMultiplier();
        Item item = stack.func_77973_b();
        if (item instanceof ItemGemDagger) {
            for (int i = 0; i < shotCount; ++i) {
                list.add(new EntityChaosProjectileHoming((EntityLivingBase)player, stack, damage, false, 0.0325, 0.25));
            }
        } else if (item instanceof ItemGemScepter) {
            for (int i = 0; i < shotCount; ++i) {
                list.add(new EntityChaosProjectileHoming((EntityLivingBase)player, stack, damage, true, 0.075, 0.35));
            }
        } else if (item instanceof ItemGemKatana) {
            float maxAngle = 0.05f;
            for (float angle = -0.05f; angle <= 0.05f; angle += 0.05f / (float)(shotCount / 2)) {
                list.add(new EntityChaosProjectileSweep((EntityLivingBase)player, stack, damage, angle));
            }
        } else if (item instanceof ItemGemMachete) {
            for (int i = 0; i < shotCount; ++i) {
                list.add(new EntityChaosProjectileScatter((EntityLivingBase)player, stack, damage));
            }
        } else {
            for (int i = 0; i < shotCount; ++i) {
                EntityChaosProjectile e = new EntityChaosProjectile((EntityLivingBase)player, stack, damage);
                e.field_70181_x += 0.2 * (double)i;
                list.add(e);
            }
        }
        return list;
    }

    private int getShotCost(EntityPlayer player, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return 0;
        }
        return EnumMagicType.getMagicType(stack).getCost(stack);
    }

    private int getShotCooldown(EntityPlayer player, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return 0;
        }
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item == ModItems.dagger) {
                return 5;
            }
            if (item == ModItems.scepter) {
                return 20;
            }
            if (item == ModItems.katana) {
                return 10;
            }
            if (item == ModItems.sword) {
                return 5;
            }
        }
        return 10;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ToolSoul soul = SoulManager.getSoul(player.func_184586_b(hand));
        if (soul != null && soul.activateSkillsOnBlock(player.func_184586_b(hand), player, world, pos, facing, hitX, hitY, hitZ)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean canceled = super.onBlockStartBreak(stack, pos, player);
        if (!canceled) {
            ToolHelper.onBlockStartBreak(stack, pos, player);
        }
        return canceled;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ToolHelper.getItemEnchantability(stack);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ToolHelper.getAttributeModifiers(slot, stack);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return ToolHelper.onBlockDestroyed(stack, world, state, pos, entityLiving);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        return ToolHelper.hitEntity(stack, entity1, entity2);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return ToolHelper.getIsRepairable(stack1, stack2);
    }

    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, "h", "h", "r");
        }
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().func_77624_a(stack, world, list, flag);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems((Item)this, 3));
    }

    public void registerModels() {
        SilentGems.registry.setModel((Item)this, 0, "tool");
    }
}

