/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.network.NetworkHandler;
import net.silentchaos512.gems.network.message.MessageSetFlight;

public class ChaosBuff {
    public static final ChaosBuff SPEED;
    public static final ChaosBuff SLOWNESS;
    public static final ChaosBuff HASTE;
    public static final ChaosBuff MINING_FATIGUE;
    public static final ChaosBuff STRENGTH;
    public static final ChaosBuff JUMP_BOOST;
    public static final ChaosBuff FLIGHT;
    public static final ChaosBuff NAUSEA;
    public static final ChaosBuff REGENERATION;
    public static final ChaosBuff RESISTANCE;
    public static final ChaosBuff FIRE_RESISTANCE;
    public static final ChaosBuff WATER_BREATHING;
    public static final ChaosBuff INVISIBILITY;
    public static final ChaosBuff BLINDNESS;
    public static final ChaosBuff NIGHT_VISION;
    public static final ChaosBuff HUNGER;
    public static final ChaosBuff WEAKNESS;
    public static final ChaosBuff POISON;
    public static final ChaosBuff WITHER;
    public static final ChaosBuff GLOWING;
    public static final ChaosBuff LEVITATION;
    public static final ChaosBuff CAPACITY;
    public static final ChaosBuff RECHARGE;
    @Nullable
    public static final ChaosBuff COLD_RESISTANCE;
    @Nullable
    public static final ChaosBuff HEAT_RESISTANCE;
    @Nullable
    public static final ChaosBuff THIRST;
    static final Map<String, ChaosBuff> buffMap;
    @Nonnull
    final String key;
    @Nullable
    final Potion potion;
    final int maxLevel;
    final int slotsUsed;
    final int chaosCost;
    final boolean variableCost;
    final int applyDuration;
    static final Potion hyperthermia;
    static final Potion hypothermia;

    public ChaosBuff(String key, int maxLevel, int slotsUsed, int chaosCost, boolean variableCost, int applyDuration, @Nullable Potion potion) {
        if (buffMap.containsKey(key)) {
            throw new IllegalArgumentException("Buff with key " + key + " has already been added!");
        }
        this.key = key;
        this.maxLevel = maxLevel;
        this.potion = potion;
        this.slotsUsed = slotsUsed;
        this.chaosCost = chaosCost;
        this.applyDuration = applyDuration;
        this.variableCost = variableCost;
        buffMap.put(key, this);
    }

    @Nullable
    public static ChaosBuff byKey(String key) {
        return buffMap.get(key);
    }

    public static Collection<ChaosBuff> getAllBuffs() {
        return buffMap.values();
    }

    public void applyToPlayer(EntityPlayer player, int level, ItemStack stack) {
        int duration;
        if (this.potion != null && (duration = this.getApplyDuration(player, level)) > 0) {
            player.func_70690_d(new PotionEffect(this.potion, duration, level - 1, false, false));
            if (this == HEAT_RESISTANCE) {
                player.func_184596_c(hyperthermia);
            } else if (this == COLD_RESISTANCE) {
                player.func_184596_c(hypothermia);
            }
        }
        if (this == FLIGHT) {
            player.field_71075_bZ.field_75101_c = true;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            if (data != null) {
                data.flightTime = 100;
            }
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetFlight(true), (EntityPlayerMP)player);
            }
        }
    }

    public void removeFromPlayer(EntityPlayer player, int level, ItemStack stack) {
        if (this.potion != null) {
            player.func_184589_d(this.potion);
        }
        if (this == FLIGHT && !player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            player.field_70143_R = 0.0f;
            if (!player.field_70170_p.field_72995_K) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetFlight(false), (EntityPlayerMP)player);
            }
        }
    }

    public int getSlotsUsed(int level) {
        if (this.slotsUsed == 0) {
            return 0;
        }
        return this.slotsUsed + (level - 1) * (this.slotsUsed / Math.abs(this.slotsUsed));
    }

    public int getChaosCost(int level, @Nullable EntityPlayer player) {
        int normalCost = this.chaosCost + this.chaosCost * (level - 1) / 5;
        if (this == FLIGHT && player != null) {
            boolean notFlying;
            boolean bl = notFlying = !player.field_71075_bZ.field_75100_b || player.field_71075_bZ.field_75098_d;
            if (notFlying && player.field_70181_x < -0.88) {
                return normalCost / 10;
            }
            if (notFlying) {
                return 0;
            }
        } else if (this == FIRE_RESISTANCE && player != null) {
            return player.func_70027_ad() ? this.chaosCost : 0;
        }
        return normalCost;
    }

    public int getApplyDuration(EntityPlayer player, int level) {
        if (this == REGENERATION || this == POISON || this == WITHER) {
            boolean shouldApply = false;
            PotionEffect activeEffect = player.func_70660_b(this.potion);
            if (activeEffect == null) {
                shouldApply = true;
            } else {
                int healTime;
                int remainingTime = activeEffect.func_76459_b();
                int n = healTime = level == 2 ? 20 : 40;
                if (remainingTime + healTime <= this.applyDuration) {
                    shouldApply = true;
                }
            }
            return shouldApply ? this.applyDuration : 0;
        }
        return this.applyDuration;
    }

    public String getLocalizedName(int level) {
        String str = this.potion != null ? SilentGems.i18n.translate(this.potion.func_76393_a(), new Object[0]) : SilentGems.i18n.translate("buff." + this.key, new Object[0]);
        if (level > 1) {
            str = str + " " + (level == 2 ? "II" : (level == 3 ? "III" : (level == 4 ? "IV" : "" + level)));
        }
        return str;
    }

    public String getDescription() {
        String descKey = "buff." + this.key + ".desc";
        String desc = SilentGems.i18n.translate(descKey, new Object[0]);
        if (!desc.equals(descKey)) {
            return desc;
        }
        if (this.potion == null) {
            return "Null potion!";
        }
        String potionName = SilentGems.i18n.translate(this.potion.func_76393_a(), new Object[0]);
        return SilentGems.i18n.itemSubText("chaosrune", "appliesEffect", new Object[]{potionName});
    }

    public int getColor() {
        if (this.potion != null) {
            return this.potion.func_76401_j();
        }
        if (this == CAPACITY) {
            return 10827977;
        }
        if (this == RECHARGE) {
            return 16775070;
        }
        return 0xFFFFFF;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public Potion getPotion() {
        return this.potion;
    }

    public boolean hasVariableCost() {
        return this.variableCost;
    }

    static {
        buffMap = new LinkedHashMap<String, ChaosBuff>();
        String prefix = "silentgems:";
        int dur = 30;
        CAPACITY = new ChaosBuff("silentgems:capacity", 4, 1, 0, false, 30, null);
        RECHARGE = new ChaosBuff("silentgems:recharge", 4, 1, 0, false, 30, null);
        FLIGHT = new ChaosBuff("silentgems:flight", 1, 10, 80, true, 30, null);
        SPEED = new ChaosBuff("silentgems:speed", 4, 4, 20, false, 30, MobEffects.field_76424_c);
        HASTE = new ChaosBuff("silentgems:haste", 2, 4, 30, false, 30, MobEffects.field_76422_e);
        JUMP_BOOST = new ChaosBuff("silentgems:jump_boost", 4, 4, 10, false, 30, MobEffects.field_76430_j);
        STRENGTH = new ChaosBuff("silentgems:strength", 2, 10, 50, false, 30, MobEffects.field_76420_g);
        REGENERATION = new ChaosBuff("silentgems:regeneration", 2, 8, 42, false, 80, MobEffects.field_76428_l);
        RESISTANCE = new ChaosBuff("silentgems:resistance", 2, 6, 40, false, 30, MobEffects.field_76429_m);
        FIRE_RESISTANCE = new ChaosBuff("silentgems:fire_resistance", 1, 8, 400, true, 30, MobEffects.field_76426_n);
        WATER_BREATHING = new ChaosBuff("silentgems:water_breathing", 1, 4, 30, false, 30, MobEffects.field_76427_o);
        NIGHT_VISION = new ChaosBuff("silentgems:night_vision", 1, 2, 10, false, 410, MobEffects.field_76439_r);
        INVISIBILITY = new ChaosBuff("silentgems:invisibility", 1, 6, 25, false, 30, MobEffects.field_76441_p);
        LEVITATION = new ChaosBuff("silentgems:levitation", 4, 3, 20, false, 30, MobEffects.field_188424_y);
        GLOWING = new ChaosBuff("silentgems:glowing", 1, 0, 5, false, 30, MobEffects.field_188423_x);
        SLOWNESS = new ChaosBuff("silentgems:slowness", 3, -2, 5, false, 30, MobEffects.field_76421_d);
        MINING_FATIGUE = new ChaosBuff("silentgems:mining_fatigue", 3, -2, 5, false, 30, MobEffects.field_76419_f);
        NAUSEA = new ChaosBuff("silentgems:nausea", 3, -4, 5, false, 30, MobEffects.field_76431_k);
        BLINDNESS = new ChaosBuff("silentgems:blindness", 3, -3, 5, false, 30, MobEffects.field_76440_q);
        HUNGER = new ChaosBuff("silentgems:hunger", 3, -2, 5, false, 30, MobEffects.field_76438_s);
        WEAKNESS = new ChaosBuff("silentgems:weakness", 3, -2, 5, false, 30, MobEffects.field_76437_t);
        POISON = new ChaosBuff("silentgems:poison", 3, -2, 5, false, 90, MobEffects.field_76436_u);
        WITHER = new ChaosBuff("silentgems:wither", 2, -3, 5, false, 80, MobEffects.field_82731_v);
        if (Loader.isModLoaded((String)"toughasnails")) {
            Potion coldResist = Potion.func_180142_b((String)"toughasnails:cold_resistance");
            Potion heatResist = Potion.func_180142_b((String)"toughasnails:heat_resistance");
            Potion thirst = Potion.func_180142_b((String)"toughasnails:thirst");
            COLD_RESISTANCE = new ChaosBuff("toughasnails:cold_resistance", 1, 8, 50, false, 30, coldResist);
            HEAT_RESISTANCE = new ChaosBuff("toughasnails:heat_resistance", 1, 8, 50, false, 30, heatResist);
            THIRST = new ChaosBuff("toughasnails:thirst", 1, -4, 5, false, 30, thirst);
        } else {
            COLD_RESISTANCE = null;
            HEAT_RESISTANCE = null;
            THIRST = null;
        }
        hyperthermia = Potion.func_180142_b((String)"toughasnails:hyperthermia");
        hypothermia = Potion.func_180142_b((String)"toughasnails:hypothermia");
    }
}

