/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.lib.NodeEffectPotion;
import net.silentchaos512.gems.util.ModDamageSource;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.PlayerHelper;

public class NodeEffect {
    public static List<NodeEffect> ALL_EFFECTS = new ArrayList<NodeEffect>();
    public static NodeEffect ATTACK = new NodeEffect("silentgems:attack", 8.0f, 0.25f, 0xFF0000, false, false, true);
    public static NodeEffect LEVITATE = new NodeEffectPotion("silentgems:levitate", 24.0f, 0.25f, 65280, false, false, true, MobEffects.field_188424_y, 60, 120, 1);
    public static NodeEffect REPAIR = new NodeEffect("silentgems:repair", 10.0f, 0.2f, 44799, true, false, false);
    public static NodeEffect REGEN = new NodeEffectPotion("silentgems:regeneration", 15.0f, 0.3f, 16737993, true, true, false, MobEffects.field_76428_l, 80, 200, 0);
    public static NodeEffect SATURATION = new NodeEffect("silentgems:saturation", 25.0f, 0.1f, 14709504, true, false, false);
    protected final String key;
    protected final int delay;
    protected final int delaySalt;
    protected final float successChance;
    public final int color;
    public final boolean targetPlayers;
    public final boolean targetPassives;
    public final boolean targetHostiles;

    public NodeEffect(String key, float delayInSeconds, float successChance, int color, boolean targetPlayers, boolean targetPassives, boolean targetHostiles) {
        this.key = key;
        this.delay = (int)(20.0f * delayInSeconds);
        this.delaySalt = (int)((double)this.delay * (SilentGems.random.nextDouble() - 0.5));
        this.successChance = successChance;
        this.color = color;
        this.targetPlayers = targetPlayers;
        this.targetPassives = targetPassives;
        this.targetHostiles = targetHostiles;
        ALL_EFFECTS.add(this);
    }

    public boolean applyToEntity(EntityLivingBase entity, Random random) {
        return this.applyToEntity(entity, random, true);
    }

    public boolean applyToEntity(EntityLivingBase entity, Random random, boolean allowSounds) {
        if (random.nextFloat() > this.successChance || !this.needsEffect(entity)) {
            return false;
        }
        if (this == ATTACK) {
            if (!entity.field_70170_p.field_72995_K) {
                entity.func_70097_a(ModDamageSource.NODE_ATTACK, (float)(4.0 + 0.75 * random.nextGaussian()));
            }
            return true;
        }
        if (this == REPAIR) {
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            EntityPlayer player = (EntityPlayer)entity;
            int amount = (int)(10.0 + 2.0 * random.nextGaussian());
            ItemStack stackToRepair = null;
            NonNullList items = PlayerHelper.getNonEmptyStacks((EntityPlayer)player);
            items.removeIf(stack -> !this.canRepair((ItemStack)stack));
            if (items.size() > 0) {
                stackToRepair = (ItemStack)items.get(random.nextInt(items.size()));
            }
            if (stackToRepair != null) {
                ItemHelper.attemptDamageItem((ItemStack)stackToRepair, (int)(-amount), (Random)random, (EntityPlayer)player);
                if (allowSounds) {
                    entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.5f, 2.0f + (float)(0.2 * random.nextGaussian()));
                }
                return true;
            }
            return false;
        }
        if (this == SATURATION) {
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71024_bL().func_75122_a(2, 0.1f);
            if (allowSounds) {
                entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 0.5f, 1.2f + (float)(0.05 * random.nextGaussian()));
            }
            return true;
        }
        if (this instanceof NodeEffectPotion) {
            NodeEffectPotion effect = (NodeEffectPotion)this;
            int duration = effect.durationMin + random.nextInt(effect.durationMax - effect.durationMin + 1);
            entity.func_70690_d(new PotionEffect(effect.potion, duration, effect.amplifier));
            return true;
        }
        SilentGems.logHelper.warn("Potentially unknown node effect: " + this.key, new Object[0]);
        return false;
    }

    protected boolean needsEffect(EntityLivingBase entity) {
        if (this == REGEN) {
            return entity.func_110143_aJ() < entity.func_110138_aP();
        }
        if (this == SATURATION) {
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            EntityPlayer player = (EntityPlayer)entity;
            return player.func_71024_bL().func_75116_a() <= 18;
        }
        return true;
    }

    public boolean isTimeToTry(long time) {
        return time % (long)(this.delay + this.delaySalt) == 0L;
    }

    protected boolean canRepair(ItemStack stack) {
        if (GemsConfig.NODE_REPAIR_BLACKLIST.contains(stack.func_77973_b())) {
            return false;
        }
        return stack.func_77952_i() > 0 && stack.func_77984_f() && (stack.func_77973_b().isRepairable() || GemsConfig.NODE_REPAIR_WHITELIST.contains(stack.func_77973_b()));
    }
}

