/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.urn;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.TileSoulUrn;
import net.silentchaos512.gems.lib.urn.UrnHelper;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.StackHelper;
import net.silentchaos512.lib.util.TimeHelper;

public class UpgradePlanter
extends UrnUpgrade {
    private static final int TICK_FREQUENCY = TimeHelper.ticksFromSeconds((float)30.0f);
    private static final Map<Item, Plant> PLANTS = new HashMap<Item, Plant>();
    private int ticks = 0;
    private static boolean initialized = false;

    @Override
    public void tickTile(TileSoulUrn.SoulUrnState state, World world, BlockPos pos) {
        if (!state.getLidState().isOpen()) {
            return;
        }
        ++this.ticks;
        if (this.ticks >= TICK_FREQUENCY) {
            Plant plant;
            this.ticks = 0;
            ItemStack seed = StackHelper.firstMatch((IInventory)state.getTileEntity(), UpgradePlanter::isGrowablePlant);
            if (!seed.func_190926_b() && (plant = PLANTS.get(seed.func_77973_b())) != null) {
                for (ItemStack stack : (Collection)plant.drops.apply(SilentGems.random)) {
                    state.getTileEntity().tryAddItemToInventory(stack);
                }
            }
        }
    }

    @Override
    public void tickItem(ItemStack urn, World world, EntityPlayer player, int itemSlot, boolean isSelected) {
        if (!UrnHelper.isLidless(urn)) {
            return;
        }
        ++this.ticks;
        if (this.ticks >= TICK_FREQUENCY) {
            Plant plant;
            this.ticks = 0;
            ItemStack seed = UrnHelper.getContainedItems(urn).firstMatch(UpgradePlanter::isGrowablePlant);
            if (seed.func_190926_b() || (plant = PLANTS.get(seed.func_77973_b())) != null) {
                // empty if block
            }
        }
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        PLANTS.put(Items.field_185163_cU, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_185164_cV), 1.0, new ItemStack(Items.field_185163_cU), 0.15)));
        PLANTS.put(Items.field_151172_bF, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_151172_bF), 1.0)));
        PLANTS.put(Item.func_150898_a((Block)Blocks.field_185766_cS), new Plant(2, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_185161_cS), 1.0, new ItemStack(Blocks.field_185766_cS), 0.05)));
        PLANTS.put(Items.field_151081_bc, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_151127_ba, random.nextInt(4) + 1), 0.85, new ItemStack(Blocks.field_150440_ba), 0.2)));
        PLANTS.put(Items.field_151075_bm, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_151075_bm, random.nextInt(3) + 1), 0.95)));
        PLANTS.put(Items.field_151174_bG, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_151174_bG), 1.0, new ItemStack(Items.field_151170_bI), 0.05)));
        PLANTS.put(Items.field_151080_bb, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Blocks.field_150423_aK), 0.85, new ItemStack(Blocks.field_150428_aP), 0.01)));
        PLANTS.put(Items.field_151120_aE, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_151120_aE, random.nextInt(2) + 1), 0.85)));
        PLANTS.put(Items.field_151014_N, new Plant(1, random -> UpgradePlanter.dropsWithChance(random, new ItemStack(Items.field_151015_O), 1.0, new ItemStack(Items.field_151014_N), 0.15)));
    }

    private static boolean isGrowablePlant(ItemStack stack) {
        return PLANTS.containsKey(stack.func_77973_b());
    }

    private static Collection<ItemStack> dropsWithChance(Random random, ItemStack stack1, double rate1) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!stack1.func_190926_b() && MathUtils.tryPercentage((Random)random, (double)rate1)) {
            builder.add((Object)stack1);
        }
        return builder.build();
    }

    private static Collection<ItemStack> dropsWithChance(Random random, ItemStack stack1, double rate1, ItemStack stack2, double rate2) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!stack1.func_190926_b() && MathUtils.tryPercentage((Random)random, (double)rate1)) {
            builder.add((Object)stack1);
        }
        if (!stack2.func_190926_b() && MathUtils.tryPercentage((Random)random, (double)rate2)) {
            builder.add((Object)stack2);
        }
        return builder.build();
    }

    public static class Plant {
        private final int growthTicks;
        private final Function<Random, Collection<ItemStack>> drops;

        public Plant(int growthRate, Function<Random, Collection<ItemStack>> drops) {
            this.growthTicks = growthRate;
            this.drops = drops;
        }
    }
}

