/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.urn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.TileSoulUrn;
import net.silentchaos512.gems.item.SoulUrnUpgrades;

public class UrnUpgrade {
    private static final Map<ResourceLocation, Serializer<? extends UrnUpgrade>> SERIALIZERS = new HashMap<ResourceLocation, Serializer<? extends UrnUpgrade>>();
    ResourceLocation id;

    public void tickTile(TileSoulUrn.SoulUrnState state, World world, BlockPos pos) {
    }

    public void tickItem(ItemStack urn, World world, EntityPlayer player, int itemSlot, boolean isSelected) {
    }

    public String getTranslationKey() {
        return "urn_upgrade." + this.id;
    }

    public static final class ListHelper {
        private ListHelper() {
        }

        public static NonNullList<UrnUpgrade> load(ItemStack urn) {
            return ListHelper.load(urn.func_190925_c("BlockEntityTag"));
        }

        public static NonNullList<UrnUpgrade> load(NBTTagCompound tagCompound) {
            NonNullList result = NonNullList.func_191196_a();
            NBTTagList tagList = tagCompound.func_150295_c("Upgrades", 10);
            for (NBTBase nbt : tagList) {
                if (!(nbt instanceof NBTTagCompound)) continue;
                NBTTagCompound tags = (NBTTagCompound)nbt;
                ResourceLocation id = new ResourceLocation(tags.func_74779_i("ID"));
                Serializer serializer = (Serializer)SERIALIZERS.get(id);
                if (serializer != null) {
                    result.add(serializer.deserialize(tags));
                    continue;
                }
                SilentGems.logHelper.error("Serializer for urn upgrade {} not found! Data will be lost.", new Object[]{id});
            }
            return result;
        }

        public static void save(List<UrnUpgrade> upgrades, NBTTagCompound tagCompound) {
            NBTTagList tagList = new NBTTagList();
            for (UrnUpgrade upgrade : upgrades) {
                Serializer serializer = (Serializer)SERIALIZERS.get(upgrade.id);
                if (serializer != null) {
                    NBTTagCompound tags = serializer.serialize();
                    tags.func_74778_a("ID", upgrade.id.toString());
                    tagList.func_74742_a((NBTBase)tags);
                    continue;
                }
                SilentGems.logHelper.error("Serializer for urn upgrade {} not found! Data will be lost.", new Object[]{upgrade.id});
            }
            tagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
        }

        public static boolean contains(List<UrnUpgrade> upgrades, Serializer<? extends UrnUpgrade> serializer) {
            for (UrnUpgrade upgrade : upgrades) {
                if (!upgrade.id.equals((Object)((Serializer)serializer).id)) continue;
                return true;
            }
            return false;
        }

        public static boolean contains(List<UrnUpgrade> upgrades, SoulUrnUpgrades upgrade) {
            return ListHelper.contains(upgrades, upgrade.getSerializer());
        }
    }

    public static class Serializer<T extends UrnUpgrade> {
        private final ResourceLocation id;
        private final Supplier<T> constructor;

        public Serializer(ResourceLocation id, Supplier<T> constructor) {
            this.id = id;
            this.constructor = constructor;
            SERIALIZERS.put(id, this);
        }

        public NBTTagCompound serialize() {
            return new NBTTagCompound();
        }

        public T deserialize(NBTTagCompound nbt) {
            UrnUpgrade result = (UrnUpgrade)this.constructor.get();
            result.id = this.id;
            return (T)result;
        }

        public ResourceLocation getId() {
            return this.id;
        }
    }
}

