/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.network.message;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.client.handler.ClientTickHandler;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.network.Message;
import net.silentchaos512.gems.util.SoulManager;

public class MessageSoulSync
extends Message {
    public long uuidMost;
    public long uuidLeast;
    public int xp;
    public int level;
    public int ap;
    public String skillLearned;
    public int skillLevel;

    public MessageSoulSync() {
    }

    public MessageSoulSync(UUID uuid, int xp, int level, int ap, SoulSkill skillLearned, int skillLevel) {
        this.uuidMost = uuid.getMostSignificantBits();
        this.uuidLeast = uuid.getLeastSignificantBits();
        this.xp = xp;
        this.level = level;
        this.ap = ap;
        this.skillLearned = skillLearned == null ? "" : skillLearned.id;
        this.skillLevel = skillLevel;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage handleMessage(MessageContext context) {
        ClientTickHandler.scheduledActions.add(() -> {
            UUID uuid = new UUID(this.uuidMost, this.uuidLeast);
            ToolSoul soul = SoulManager.getSoulByUuid(uuid);
            if (soul != null) {
                soul.setXp(this.xp);
                soul.setLevel(this.level);
                soul.setActionPoints(this.ap);
                if (this.skillLearned != null && !this.skillLearned.isEmpty()) {
                    SoulSkill skill = SoulSkill.getById(this.skillLearned);
                    soul.setSkillLevel(skill, this.skillLevel, ItemStack.field_190927_a, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
            }
        });
        return null;
    }
}

