/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.potion;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.util.ModDamageSource;
import net.silentchaos512.lib.util.Color;

public class PotionShocking
extends Potion {
    public static final int CONTINUOUS_DAMAGE_DELAY = 15;
    public static final int CONTINUOUS_DAMAGE_AMOUNT = 1;
    public static final int CHAIN_DELAY = 5;
    public static final double CHAIN_RADIUS_SQUARED = 6.25;
    public static boolean CONTINUOUS_DAMAGE_ENABLED = true;
    public static boolean CHAINING_ENABLED = true;
    public AttributeModifier modifier;

    public PotionShocking() {
        super(true, 16121661);
        this.func_76390_b("effect.silentgems.shocking");
        this.modifier = new AttributeModifier(UUID.fromString("966ce179-1967-4b80-b894-bc743f1edbef"), this.func_76393_a(), -0.3, 2);
    }

    public void func_76394_a(EntityLivingBase entityLiving, int amplifier) {
        PotionEffect effect = entityLiving.func_70660_b((Potion)this);
        if (effect == null) {
            return;
        }
        int shockTimer = effect.func_76459_b();
        if (!entityLiving.field_70170_p.field_72995_K && CHAINING_ENABLED) {
            int halfTime = shockTimer / 2;
            if (shockTimer % 5 == 0 && halfTime > 0) {
                for (EntityLivingBase nearby : entityLiving.field_70170_p.func_175644_a(EntityLivingBase.class, e -> e.func_70068_e((Entity)entityLiving) < 6.25 && !(e instanceof EntityPlayer))) {
                    PotionEffect effectNearby = nearby.func_70660_b((Potion)this);
                    if (effectNearby != null) continue;
                    nearby.func_70690_d(new PotionEffect((Potion)this, halfTime, 0, true, false));
                }
            }
        }
        if (!entityLiving.field_70170_p.field_72995_K && CONTINUOUS_DAMAGE_ENABLED) {
            int damageDelay = 15;
            if ((shockTimer + entityLiving.func_145782_y()) % damageDelay == 0) {
                boolean damageAmount = true;
                entityLiving.func_70097_a(ModDamageSource.SHOCKING, (float)damageAmount);
            }
        }
        Random rand = SilentGems.random;
        for (int i = 0; i < 3 - SilentGems.proxy.getParticleSettings(); ++i) {
            double posX = entityLiving.field_70165_t + (double)(1.2f * (rand.nextFloat() - 0.5f) * entityLiving.field_70130_N);
            double posY = entityLiving.field_70163_u + (double)(1.1f * rand.nextFloat() * entityLiving.field_70131_O);
            double posZ = entityLiving.field_70161_v + (double)(1.2f * (rand.nextFloat() - 0.5f) * entityLiving.field_70130_N);
            double motionX = 0.02 * rand.nextGaussian();
            double motionY = 0.05 + Math.abs(0.1 * rand.nextGaussian());
            double motionZ = 0.02 * rand.nextGaussian();
            SilentGems.proxy.spawnParticles(EnumModParticles.SHOCKING, new Color(16772963), entityLiving.field_70170_p, posX, posY, posZ, motionX, motionY, motionZ);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_111185_a(EntityLivingBase entityLiving, AbstractAttributeMap attributeMap, int amplifier) {
        IAttributeInstance iattributeinstance = attributeMap.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (iattributeinstance != null) {
            double amount = this.modifier.func_111164_d() * (double)(amplifier + 1);
            if (entityLiving instanceof EntityPlayer) {
                amount /= 2.0;
            }
            iattributeinstance.func_111124_b(this.modifier);
            iattributeinstance.func_111121_a(new AttributeModifier(this.modifier.func_111167_a(), this.func_76393_a() + " " + amplifier, amount, this.modifier.func_111169_c()));
        }
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (iattributeinstance != null) {
            iattributeinstance.func_111124_b(this.modifier);
        }
    }
}

