/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IAmmoTool;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.api.tool.part.ToolPartTip;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.recipe.RecipeBaseSL;
import net.silentchaos512.lib.util.ItemHelper;

public class RecipeDecorateTool
extends RecipeBaseSL {
    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        return !this.func_77572_b(inventoryCrafting).func_190926_b();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack stack;
        int toolRow = 0;
        int toolCol = 0;
        ItemStack tool = ItemStack.field_190927_a;
        int repairValue = 0;
        int ammoValue = 0;
        for (int row = 0; row < inv.func_174922_i(); ++row) {
            for (int col = 0; col < inv.func_174923_h(); ++col) {
                stack = inv.func_70463_b(row, col);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ITool)) continue;
                tool = stack;
                toolRow = row;
                toolCol = col;
            }
        }
        if (tool.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack west = inv.func_70463_b(toolRow - 1, toolCol);
        ItemStack north = inv.func_70463_b(toolRow, toolCol - 1);
        ItemStack east = inv.func_70463_b(toolRow + 1, toolCol);
        ItemStack south = inv.func_70463_b(toolRow, toolCol + 1);
        if (!(this.checkIsDecorationMaterial(west) && this.checkIsDecorationMaterial(north) && this.checkIsDecorationMaterial(east) && this.checkIsDecorationMaterial(south))) {
            return ItemStack.field_190927_a;
        }
        ArrayList otherMats = Lists.newArrayList();
        EnumMaterialTier toolTier = ToolHelper.getToolTier(tool);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() instanceof ITool) continue;
            ToolPart part = ToolPartRegistry.fromDecoStack(stack);
            if (part == null) {
                return ItemStack.field_190927_a;
            }
            if (!part.validForToolOfTier(toolTier) && !(part instanceof ToolPartMain)) {
                return ItemStack.field_190927_a;
            }
            int repairAmount = part.getRepairAmount(tool, stack);
            if (repairAmount > 0) {
                repairValue += repairAmount;
                ++ammoValue;
            }
            otherMats.add(stack);
        }
        if (otherMats.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = tool.func_77946_l();
        result = ToolHelper.decorateTool(tool, west, north, east, south);
        boolean lockedStats = result.func_77978_p().func_74767_n("SG_LockStats");
        for (ItemStack other : otherMats) {
            ToolPart part = ToolPartRegistry.fromDecoStack(other);
            EnumMaterialGrade grade = EnumMaterialGrade.fromStack(other);
            if (!result.func_190926_b() && part instanceof ToolPartRod) {
                ToolHelper.setRenderPart(result, part, grade, ToolPartPosition.ROD);
                continue;
            }
            if (!(part instanceof ToolPartTip)) continue;
            if (lockedStats) {
                return ItemStack.field_190927_a;
            }
            ToolHelper.setConstructionTip(result, part);
        }
        if (repairValue > 0) {
            ++repairValue;
        }
        repairValue = (int)((float)repairValue * ((ITool)tool.func_77973_b()).getRepairMultiplier());
        ItemHelper.attemptDamageItem((ItemStack)result, (int)(-repairValue), (Random)SilentGems.random);
        if (result.func_77973_b() instanceof IAmmoTool && ammoValue > 0) {
            IAmmoTool ammoTool = (IAmmoTool)result.func_77973_b();
            ammoTool.addAmmo(result, ammoValue * GemsConfig.TOMAHAWK_AMMO_PER_MAT);
        }
        ToolHelper.recalculateStats(result);
        ToolHelper.incrementStatRedecorated(result, 1);
        result.func_77978_p().func_82580_o("SG_UUIDMost");
        result.func_77978_p().func_82580_o("SG_UUIDLeast");
        ToolHelper.getUUID(result);
        return result;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    private boolean checkIsDecorationMaterial(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        ToolPart part = ToolPartRegistry.fromDecoStack(stack);
        return part != null;
    }
}

