/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.block.BlockTeleporter;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemTeleporterLinker;
import net.silentchaos512.gems.util.ChaosUtil;
import net.silentchaos512.gems.util.TeleportUtil;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.DimensionalPosition;
import net.silentchaos512.lib.util.LogHelper;

public class TileTeleporter
extends TileEntity
implements IChaosAccepter {
    protected DimensionalPosition destination = null;
    protected int chaosStored = 0;
    public boolean isAnchor = false;

    public TileTeleporter() {
    }

    public TileTeleporter(boolean isAnchor) {
        this.isAnchor = isAnchor;
    }

    public DimensionalPosition getDestination() {
        return this.destination;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.destination = DimensionalPosition.readFromNBT((NBTTagCompound)tags);
        this.chaosStored = tags.func_74762_e("Energy");
        this.isAnchor = tags.func_74767_n("IsAnchor");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        if (this.destination != null) {
            this.destination.writeToNBT(tags);
        }
        tags.func_74768_a("Energy", this.chaosStored);
        tags.func_74757_a("IsAnchor", this.isAnchor);
        return tags;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        if (this.destination != null && !this.destination.equals((Object)DimensionalPosition.ZERO)) {
            this.destination.writeToNBT(tags);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tags);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        if (this.destination != null && !this.destination.equals((Object)DimensionalPosition.ZERO)) {
            this.destination.writeToNBT(tags);
        }
        return tags;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.destination = DimensionalPosition.readFromNBT((NBTTagCompound)packet.func_148857_g());
    }

    public boolean linkReturnHomeCharm(EntityPlayer player, World world, BlockPos pos, ItemStack heldItem, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        if (!heldItem.func_77942_o()) {
            heldItem.func_77982_d(new NBTTagCompound());
        }
        DimensionalPosition position = new DimensionalPosition(pos, player.field_71093_bK);
        position.writeToNBT(heldItem.func_77978_p());
        ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "returnHomeBound", new Object[0]));
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, heldItem);
        }
        return true;
    }

    public boolean linkTeleporters(EntityPlayer player, World world, BlockPos pos, ItemStack heldItem, EnumHand hand) {
        if (world.field_72995_K) {
            return true;
        }
        LogHelper log = SilentGems.logHelper;
        ItemTeleporterLinker linker = ModItems.teleporterLinker;
        if (heldItem.func_190926_b() || heldItem.func_77973_b() != linker) {
            log.warn("TileTeleporter.linkTeleporters: heldItem is not a linker?", new Object[0]);
            return false;
        }
        if (linker.isLinked(heldItem)) {
            DimensionalPosition position1 = linker.getLinkedPosition(heldItem);
            DimensionalPosition position2 = new DimensionalPosition(pos, player.field_71093_bK);
            if (position1 == null) {
                log.warn("Teleporter Linker tried to link with no position set?", new Object[0]);
                return true;
            }
            TileTeleporter tile1 = (TileTeleporter)player.func_184102_h().func_71218_a(position1.dim).func_175625_s(position1.toBlockPos());
            TileTeleporter tile2 = (TileTeleporter)player.func_184102_h().func_71218_a(position2.dim).func_175625_s(position2.toBlockPos());
            if (tile1 == null || tile2 == null) {
                ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "linkFail", new Object[0]));
                log.warn("Could not find teleporter when linking: Teleporter1 @ " + position1 + "; Teleporter2 @ " + position2, new Object[0]);
                linker.setLinked(heldItem, false);
                return false;
            }
            tile1.destination = position2;
            tile2.destination = position1;
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "linkSuccess", new Object[0]));
            linker.setLinked(heldItem, false);
            tile1.func_70296_d();
            tile2.func_70296_d();
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, heldItem);
            }
        } else {
            linker.setLinkedPosition(heldItem, new DimensionalPosition(pos, player.field_71093_bK));
            linker.setLinked(heldItem, true);
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.blockSubText("teleporter", "linkStart", new Object[0]));
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, chunk, state, state, 2);
    }

    public boolean checkAndDrainChaos(EntityPlayer player) {
        int available;
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int cost = this.getRequiredChaos(player);
        if (cost > (available = this.getCharge() + ChaosUtil.getTotalChaosAvailable(player))) {
            String str = SilentGems.i18n.blockSubText("teleporter", "notEnoughChaos", new Object[0]);
            str = String.format(str, this.getCharge(), cost);
            ChatHelper.sendMessage((EntityPlayer)player, (String)str);
            return false;
        }
        if (cost > this.chaosStored) {
            this.chaosStored = 0;
            ChaosUtil.drainChaosFromPlayerAndInventory(player, cost -= this.chaosStored);
        } else {
            this.chaosStored -= cost;
        }
        return true;
    }

    public int getRequiredChaos(EntityPlayer player) {
        if (this.destination == null || this.destination.equals((Object)DimensionalPosition.ZERO)) {
            return 0;
        }
        DimensionalPosition source = new DimensionalPosition(this.field_174879_c, player.field_71093_bK);
        if (source.dim != this.destination.dim) {
            return GemsConfig.TELEPORTER_COST_CROSS_DIMENSION;
        }
        double distance = this.getDistanceBetweenTeleporters(source);
        if (distance < (double)GemsConfig.TELEPORTER_FREE_RANGE) {
            return 0;
        }
        return MathHelper.func_76125_a((int)((int)((double)GemsConfig.TELEPORTER_COST_PER_BLOCK * distance)), (int)0, (int)this.getMaxCharge());
    }

    public double getDistanceBetweenTeleporters(DimensionalPosition source) {
        if (this.destination == null || this.destination.equals((Object)DimensionalPosition.ZERO)) {
            return 0.0;
        }
        double x = source.x - this.destination.x;
        double z = source.z - this.destination.z;
        return Math.sqrt(x * x + z * z);
    }

    public boolean isDestinationSafe(EntityPlayer player) {
        if (player == null || this.destination == null || this.destination.equals((Object)DimensionalPosition.ZERO)) {
            return true;
        }
        return !player.func_184102_h().func_71218_a(this.destination.dim).func_175677_d(this.destination.toBlockPos().func_177981_b(2), false);
    }

    public boolean isDestinationSane(EntityPlayer player) {
        if (player == null || this.destination == null || this.destination.equals((Object)DimensionalPosition.ZERO)) {
            return true;
        }
        return this.destination.y >= 0 && this.destination.y < 256;
    }

    public boolean isDestinationAllowedIfDumb(EntityPlayer player) {
        if (player == null || GemsConfig.TELEPORTER_ALLOW_DUMB || this.destination == null || this.destination.equals((Object)DimensionalPosition.ZERO)) {
            return true;
        }
        MinecraftServer server = player.func_184102_h();
        return server != null && server.func_71218_a(this.destination.dim).func_180495_p(this.destination.toBlockPos()).func_177230_c() instanceof BlockTeleporter;
    }

    public boolean isDestinationSet() {
        return this.destination != null && !this.destination.equals((Object)DimensionalPosition.ZERO);
    }

    public boolean teleportEntityToDestination(Entity entity) {
        if (this.destination == null || this.destination.equals((Object)DimensionalPosition.ZERO)) {
            return false;
        }
        return TeleportUtil.teleport(entity, this.destination);
    }

    @Override
    public int getCharge() {
        return this.chaosStored;
    }

    @Override
    public int getMaxCharge() {
        return this.isAnchor ? 0 : GemsConfig.TELEPORTER_MAX_CHARGE;
    }

    @Override
    public int receiveCharge(int maxReceive, boolean simulate) {
        int amount = Math.min(this.getMaxCharge() - this.getCharge(), maxReceive);
        if (!simulate) {
            this.chaosStored += amount;
        }
        return amount;
    }
}

