/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.api.energy.IChaosStorage;
import net.silentchaos512.gems.compat.BaublesCompat;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.util.NodePacketHelper;
import net.silentchaos512.lib.util.PlayerHelper;

public class ChaosUtil {
    public static List<IChaosAccepter> getNearbyAccepters(World world, BlockPos center, int horizontalRadius, int verticalRadius) {
        ArrayList list = Lists.newArrayList();
        int startX = center.func_177958_n() - horizontalRadius;
        int endX = center.func_177958_n() + horizontalRadius + 1;
        int startZ = center.func_177952_p() - horizontalRadius;
        int endZ = center.func_177952_p() + horizontalRadius + 1;
        int startY = center.func_177956_o() - verticalRadius;
        int endY = center.func_177956_o() + verticalRadius + 1;
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                for (int z = startZ; z < endZ; ++z) {
                    BlockPos targetPos = new BlockPos(x, y, z);
                    TileEntity tile = world.func_175625_s(targetPos);
                    if (tile == null || !(tile instanceof IChaosAccepter) || !ChaosUtil.canSee(world, center, targetPos)) continue;
                    list.add((IChaosAccepter)tile);
                }
            }
        }
        return list;
    }

    public static boolean canSee(World world, BlockPos source, BlockPos target) {
        Vec3d startPos = new Vec3d((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5);
        Vec3d targetPos = new Vec3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5);
        Vec3d direction = targetPos.func_178788_d(startPos).func_72432_b();
        RayTraceResult result = world.func_147447_a(startPos = startPos.func_178787_e(direction), targetPos, false, true, false);
        return result == null || result.func_178782_a().equals((Object)target);
    }

    public static boolean canSee(World world, BlockPos source, Entity target) {
        Vec3d targetPos;
        Vec3d startPos = new Vec3d((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5);
        RayTraceResult result = world.func_147447_a(startPos, targetPos = target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0), false, true, false);
        return result == null || result.func_178782_a().equals((Object)target.func_180425_c().func_177981_b((int)(target.field_70131_O / 2.0f)));
    }

    public static int getTotalChaosAvailable(EntityPlayer player) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        int amount = data.getCurrentChaos();
        for (ItemStack stack : ChaosUtil.getChaosStorageItems(player)) {
            if (!(stack.func_77973_b() instanceof IChaosStorage)) continue;
            amount += ((IChaosStorage)stack.func_77973_b()).getCharge(stack);
        }
        return amount;
    }

    public static void drainChaosFromPlayerAndInventory(EntityPlayer player, int amount) {
        ItemStack stack;
        int startAmount = amount;
        Iterator iterator = ChaosUtil.getChaosStorageItems(player).iterator();
        while (iterator.hasNext() && (!((stack = (ItemStack)iterator.next()).func_77973_b() instanceof IChaosStorage) || (amount -= ((IChaosStorage)stack.func_77973_b()).extractCharge(stack, amount, false)) > 0)) {
        }
        PlayerDataHandler.get(player).drainChaos(amount);
    }

    @Deprecated
    public static boolean canPlayerAcceptFullAmount(EntityPlayer player, int amount) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        amount -= data.getMaxChaos() - data.getCurrentChaos();
        for (ItemStack stack : ChaosUtil.getChaosStorageItems(player)) {
            if (!(stack.func_77973_b() instanceof IChaosStorage)) continue;
            amount -= ((IChaosStorage)stack.func_77973_b()).receiveCharge(stack, amount, true);
        }
        return amount <= 0;
    }

    public static int getAmountPlayerCanAccept(EntityPlayer player, int maxToSend) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        int amount = data.getMaxChaos() - data.getCurrentChaos();
        for (ItemStack stack : ChaosUtil.getChaosStorageItems(player)) {
            if ((amount += ((IChaosStorage)stack.func_77973_b()).receiveCharge(stack, maxToSend - amount, true)) < maxToSend) continue;
            return maxToSend;
        }
        return amount;
    }

    public static boolean sendEnergyTo(World world, BlockPos start, EntityLivingBase target, int amount) {
        if (target instanceof EntityPlayer) {
            ItemStack stack;
            EntityPlayer player = (EntityPlayer)target;
            amount -= PlayerDataHandler.get(player).sendChaos(amount, true);
            Iterator iterator = ChaosUtil.getChaosStorageItems(player).iterator();
            while (iterator.hasNext() && (!((stack = (ItemStack)iterator.next()).func_77973_b() instanceof IChaosStorage) || (amount -= ((IChaosStorage)stack.func_77973_b()).receiveCharge(stack, amount, false)) > 0)) {
            }
            NodePacketHelper.spawnParticles(world, start, target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0), 0xFFFF99);
            return true;
        }
        return false;
    }

    public static boolean sendEnergyTo(World world, BlockPos start, BlockPos target, int amount) {
        TileEntity tile = world.func_175625_s(target);
        if (tile instanceof IChaosAccepter) {
            ((IChaosAccepter)tile).receiveCharge(amount, false);
            NodePacketHelper.spawnParticles(world, start, target, 0xFFFF99);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> getChaosStorageItems(EntityPlayer player) {
        NonNullList<ItemStack> list = BaublesCompat.getBaubles(player, s -> s.func_77973_b() instanceof IChaosStorage);
        for (ItemStack stack : PlayerHelper.getNonEmptyStacks((EntityPlayer)player)) {
            if (!(stack.func_77973_b() instanceof IChaosStorage)) continue;
            list.add((Object)stack);
        }
        return list;
    }
}

