/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.network.NetworkHandler;
import net.silentchaos512.gems.network.message.MessageTransferParticles;
import net.silentchaos512.lib.util.Color;

public final class NodePacketHelper {
    private NodePacketHelper() {
    }

    public static void spawnParticles(World world, BlockPos from, BlockPos to, int color) {
        NodePacketHelper.spawnParticles(world, new Vec3d((double)from.func_177958_n() + 0.5, (double)from.func_177956_o() + 0.5, (double)from.func_177952_p() + 0.5), new Vec3d((double)to.func_177958_n() + 0.5, (double)to.func_177956_o() + 0.5, (double)to.func_177952_p() + 0.5), color);
    }

    public static void spawnParticles(World world, BlockPos from, Vec3d to, int color) {
        NodePacketHelper.spawnParticles(world, new Vec3d((double)from.func_177958_n() + 0.5, (double)from.func_177956_o() + 0.5, (double)from.func_177952_p() + 0.5), to, color);
    }

    public static void spawnParticles(World world, Vec3d from, Vec3d to, int color) {
        if (!world.field_72995_K) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), from.field_72450_a, from.field_72448_b, from.field_72449_c, 64.0);
            NetworkHandler.INSTANCE.sendToAllAround((IMessage)new MessageTransferParticles(from, to, color), point);
            return;
        }
        int stepCount = 20 - 4 * SilentGems.proxy.getParticleSettings();
        double stepX = (to.field_72450_a - from.field_72450_a) / (double)stepCount;
        double stepY = (to.field_72448_b - from.field_72448_b) / (double)stepCount;
        double stepZ = (to.field_72449_c - from.field_72449_c) / (double)stepCount;
        for (int i = 0; i <= stepCount; ++i) {
            double x = from.field_72450_a + stepX * (double)i;
            double y = from.field_72448_b + stepY * (double)i;
            double z = from.field_72449_c + stepZ * (double)i;
            double motionX = 0.0075 * SilentGems.random.nextGaussian();
            double motionY = 0.0075 * SilentGems.random.nextGaussian();
            double motionZ = 0.0075 * SilentGems.random.nextGaussian();
            for (int j = 0; j < 4 - SilentGems.proxy.getParticleSettings(); ++j) {
                SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS_PACKET_TAIL, new Color(color), world, x, y, z, motionX, motionY, motionZ);
            }
        }
    }
}

