/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.IGearItem;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.PlayerHelper;

public class SoulManager {
    private static final int CLEAR_DELAY = 18000;
    private static Map<UUID, ToolSoul> map = new HashMap<UUID, ToolSoul>();
    private static int ticks = 0;

    @Nullable
    public static ToolSoul getSoul(ItemStack tool) {
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ITool) && !(tool.func_77973_b() instanceof IArmor) && !SGearProxy.isGearItem(tool) || ToolHelper.isExampleItem(tool)) {
            return null;
        }
        UUID uuid = ToolHelper.getSoulUUID(tool);
        ToolSoul soul = map.get(uuid);
        if (soul != null) {
            return soul;
        }
        ToolHelper.initRootTag(tool);
        if (!tool.func_77978_p().func_74764_b("SGToolSoul")) {
            return null;
        }
        soul = ToolSoul.readFromNBT(ToolHelper.getRootTag(tool, "SGToolSoul"));
        if (uuid == null) {
            ToolHelper.setRandomSoulUUID(tool);
            uuid = ToolHelper.getSoulUUID(tool);
        }
        map.put(uuid, soul);
        return soul;
    }

    @Nullable
    public static ToolSoul getSoulByUuid(UUID uuid) {
        return map.get(uuid);
    }

    public static void setSoul(ItemStack tool, ToolSoul soul, boolean randomizeUuid) {
        ToolHelper.initRootTag(tool);
        NBTTagCompound tags = new NBTTagCompound();
        soul.writeToNBT(tags);
        tool.func_77978_p().func_74782_a("SGToolSoul", (NBTBase)tags);
        if (randomizeUuid) {
            ToolHelper.setRandomSoulUUID(tool);
        }
        if (SGearProxy.isGearItem(tool)) {
            SGearProxy.addSoulPart(tool);
        }
    }

    public static void addSoulXp(int amount, ItemStack tool, EntityPlayer player) {
        ToolSoul soul = SoulManager.getSoul(tool);
        if (soul != null && amount > 0) {
            int current = soul.getXp();
            soul.addXp(amount, tool, player);
        }
    }

    public static void queueSoulsForWrite(EntityPlayer player) {
        for (ItemStack tool : PlayerHelper.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)true, s -> s.func_77973_b() instanceof IGearItem)) {
            ToolSoul soul = SoulManager.getSoul(tool);
            if (soul == null) continue;
            soul.setReadyToSave(true);
        }
    }

    public static void writeToolSoulsToNBT(EntityPlayer player) {
        int count = 0;
        for (ItemStack tool : PlayerHelper.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)true, s -> s.func_77973_b() instanceof ITool || s.func_77973_b() instanceof IArmor || SGearProxy.isGearItem(s))) {
            ToolSoul soul = SoulManager.getSoul(tool);
            if (soul == null) continue;
            SoulManager.setSoul(tool, soul, false);
            ++count;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (event.phase == TickEvent.Phase.END && (event instanceof TickEvent.ClientTickEvent || event instanceof TickEvent.ServerTickEvent) && ++ticks % 18000 == 0) {
            map.clear();
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityLivingBase hurt = event.getEntityLiving();
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack mainHand = player.func_184614_ca();
            ToolSoul toolSoul = SoulManager.getSoul(mainHand);
            if (toolSoul != null) {
                toolSoul.activateSkillsOnEntity(mainHand, player, hurt);
                float damageAmount = Math.min(event.getAmount(), hurt.func_110138_aP());
                int xp = Math.round(0.35f * damageAmount);
                xp = MathHelper.func_76125_a((int)xp, (int)1, (int)1000);
                toolSoul.addXp(xp, mainHand, player);
            }
        }
    }

    @SubscribeEvent
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack mainHand = player.func_184614_ca();
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.gravity, (ItemStack)mainHand) > 0) {
            return;
        }
        ToolSoul soul = SoulManager.getSoul(mainHand);
        if (soul != null) {
            int aquatic = soul.getSkillLevel(SoulSkill.AQUATIC);
            int aerial = soul.getSkillLevel(SoulSkill.AERIAL);
            if (aquatic > 0 && player.func_70055_a(Material.field_151586_h)) {
                event.setNewSpeed(event.getNewSpeed() * (5.0f / (float)(SoulSkill.AQUATIC.maxLevel - aquatic + 1)));
            } else if (aerial > 0 && (!player.field_70122_E || player.field_71075_bZ.field_75100_b)) {
                event.setNewSpeed(event.getNewSpeed() * (5.0f / (float)(SoulSkill.AERIAL.maxLevel - aerial + 1)));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDamage(LivingHurtEvent event) {
        if (event.getSource() == DamageSource.field_76379_h && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            ToolSoul soulMain = SoulManager.getSoul(mainHand);
            ToolSoul soulOff = SoulManager.getSoul(offHand);
            int levelMain = soulMain == null ? 0 : soulMain.getSkillLevel(SoulSkill.AERIAL);
            int levelOff = soulOff == null ? 0 : soulOff.getSkillLevel(SoulSkill.AERIAL);
            ToolSoul soulToDrain = levelMain > levelOff ? soulMain : soulOff;
            int aerialLevel = Math.max(levelMain, levelOff);
            if (aerialLevel > 0) {
                float amountToReduce = Math.max((float)(2 + 2 * aerialLevel), 0.15f * (float)aerialLevel * event.getAmount());
                event.setAmount(event.getAmount() - amountToReduce);
                soulToDrain.addActionPoints(-SoulSkill.AERIAL.apCost);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.func_70086_ai() < 5) {
            EntityPlayer player = event.player;
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            ToolSoul soulMain = SoulManager.getSoul(mainHand);
            ToolSoul soulOff = SoulManager.getSoul(offHand);
            int levelMain = soulMain == null ? 0 : soulMain.getSkillLevel(SoulSkill.AQUATIC);
            int levelOff = soulOff == null ? 0 : soulOff.getSkillLevel(SoulSkill.AQUATIC);
            ToolSoul soulToDrain = levelMain > levelOff ? soulMain : soulOff;
            int aquaticLevel = Math.max(levelMain, levelOff);
            if (aquaticLevel > 0) {
                int amountToRestore = 60 * aquaticLevel;
                player.func_70050_g(player.func_70086_ai() + amountToRestore);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_193805_fG, SoundCategory.PLAYERS, 1.0f, 1.0f);
                soulToDrain.addActionPoints(-SoulSkill.AQUATIC.apCost);
            }
        }
    }
}

