/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.gui.font;

import com.fred.jianghun.truergb.Colors;
import com.fred.jianghun.truergb.RGBSettings;
import com.fred.jianghun.truergb.Utils;
import github.kasuminova.stellarcore.mixin.rgbchat.MixinRGBSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;

public class RGBSettingsUtils {
    public static List<Tuple<String, String>> splitRGBAndContents(String str) {
        if (str != null && !str.isEmpty()) {
            ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
            Matcher matcher = RGBSettings.PATTERN.matcher(str);
            int index = 0;
            RGBSettings lastSettings = RGBSettings.EMPTY;
            while (matcher.find(index)) {
                String format;
                String subString = str.substring(index, matcher.start());
                if (!subString.isEmpty()) {
                    lastSettings.addLength(subString.length());
                    result.add((Tuple<String, String>)new Tuple((Object)RGBSettingsUtils.serializeRGBSettings(lastSettings), (Object)subString));
                }
                if ((format = matcher.group()).startsWith("#")) {
                    String fString = matcher.group("rgb");
                    lastSettings = new RGBSettings(Arrays.stream(fString.split("-")).map(Colors::of).collect(Collectors.toList()));
                } else if (format.startsWith("\u00a7")) {
                    TextFormatting formatting = Utils.formattingOf((char)format.charAt(1));
                    if (formatting == null) {
                        throw new NullPointerException("Format: " + format);
                    }
                    lastSettings = lastSettings.withFormat(formatting);
                } else {
                    throw new IllegalStateException("Format: " + format);
                }
                index = matcher.end();
            }
            String remainingString = str.substring(index);
            lastSettings.addLength(remainingString.length());
            result.add(new Tuple((Object)RGBSettingsUtils.serializeRGBSettings(lastSettings), (Object)remainingString));
            return result;
        }
        return Collections.singletonList(new Tuple((Object)"", (Object)""));
    }

    public static String serializeRGBSettings(RGBSettings rgbSettings) {
        Boolean obfuscated;
        Boolean strikethrough;
        Boolean underlined;
        Boolean italic;
        Boolean bold;
        StringBuilder result = new StringBuilder();
        List colorStrings = ((MixinRGBSettings)rgbSettings).getColors().stream().map(color -> String.format("%06X", color.toInt() & 0xFFFFFF)).collect(Collectors.toList());
        if (!colorStrings.isEmpty()) {
            result.append('#').append(String.join((CharSequence)"-", colorStrings));
        }
        if ((bold = rgbSettings.getBold()) != null && bold.booleanValue()) {
            result.append("\u00a7l");
        }
        if ((italic = rgbSettings.getItalic()) != null && italic.booleanValue()) {
            result.append("\u00a7o");
        }
        if ((underlined = rgbSettings.getUnderlined()) != null && underlined.booleanValue()) {
            result.append("\u00a7n");
        }
        if ((strikethrough = rgbSettings.getStrikethrough()) != null && strikethrough.booleanValue()) {
            result.append("\u00a7m");
        }
        if ((obfuscated = rgbSettings.getObfuscated()) != null && obfuscated.booleanValue()) {
            result.append("\u00a7k");
        }
        return result.toString();
    }
}

