/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.hudcaching;

import com.github.lunatrius.ingameinfo.handler.Ticker;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.mixin.minecraft.hudcaching.AccessorGuiIngameForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class HUDCaching {
    public static final HUDCaching INSTANCE = new HUDCaching();
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static Framebuffer framebuffer = null;
    public static boolean dirty = true;
    public static boolean renderingCacheOverride = false;
    public static boolean igiRendering = false;
    private static long lastRenderMS = 0L;

    private HUDCaching() {
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !OpenGlHelper.func_148822_b() && HUDCaching.MC.field_71439_g != null) {
            StellarCoreConfig.PERFORMANCE.vanilla.hudCaching = false;
        }
    }

    public static void renderCachedHud(EntityRenderer renderer, GuiIngame ingame, float partialTicks) {
        if (!OpenGlHelper.func_148822_b() || !StellarCoreConfig.PERFORMANCE.vanilla.hudCaching) {
            ingame.func_175180_a(partialTicks);
            return;
        }
        GlStateManager.func_179126_j();
        ScaledResolution resolution = new ScaledResolution(MC);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        renderer.func_78478_c();
        GlStateManager.func_179147_l();
        if (framebuffer != null) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            if (ingame instanceof GuiIngameForge) {
                ((AccessorGuiIngameForge)ingame).callRenderCrosshairs(partialTicks);
            } else if (GuiIngameForge.renderCrosshairs) {
                MC.func_110434_K().func_110577_a(Gui.field_110324_m);
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
                GlStateManager.func_179141_d();
                HUDCaching.drawTexturedModalRect(tessellator, worldRenderer, (width >> 1) - 7, (height >> 1) - 7);
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)1, (int)771, (int)1, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            framebuffer.func_147612_c();
            HUDCaching.drawTexturedRect(tessellator, worldRenderer, (float)resolution.func_78327_c(), (float)resolution.func_78324_d());
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        }
        int timeRange = 1000 / StellarCoreConfig.PERFORMANCE.vanilla.hudCachingFPSLimit;
        if (System.currentTimeMillis() - lastRenderMS > (long)timeRange) {
            dirty = true;
            lastRenderMS = System.currentTimeMillis();
        }
        if (framebuffer == null || dirty) {
            dirty = false;
            framebuffer = HUDCaching.checkFramebufferSizes(framebuffer, HUDCaching.MC.field_71443_c, HUDCaching.MC.field_71440_d);
            framebuffer.func_147614_f();
            framebuffer.func_147610_a(false);
            GlStateManager.func_179084_k();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            renderingCacheOverride = true;
            ingame.func_175180_a(partialTicks);
            renderingCacheOverride = false;
            MC.func_147110_a().func_147610_a(false);
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179126_j();
        if (Loader.isModLoaded((String)"ingameinfoxml") && StellarCoreConfig.PERFORMANCE.inGameInfoXML.hudFrameBuffer) {
            HUDCaching.renderIGIOverlay(partialTicks);
        }
    }

    @Optional.Method(modid="ingameinfoxml")
    private static void renderIGIOverlay(float partialTicks) {
        igiRendering = true;
        Ticker.INSTANCE.onRenderTick(new TickEvent.RenderTickEvent(TickEvent.Phase.END, partialTicks));
        igiRendering = false;
    }

    private static Framebuffer checkFramebufferSizes(Framebuffer framebuffer, int width, int height) {
        if (framebuffer == null || framebuffer.field_147621_c != width || framebuffer.field_147618_d != height) {
            if (framebuffer == null) {
                framebuffer = new Framebuffer(width, height, true);
                framebuffer.field_147625_i[0] = 0.0f;
                framebuffer.field_147625_i[1] = 0.0f;
                framebuffer.field_147625_i[2] = 0.0f;
            } else {
                framebuffer.func_147613_a(width, height);
            }
            framebuffer.func_147607_a(9728);
        }
        return framebuffer;
    }

    private static void drawTexturedRect(Tessellator tessellator, BufferBuilder buffer, float width, float height) {
        GlStateManager.func_179098_w();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, (double)height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)width, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    private static void drawTexturedModalRect(Tessellator tessellator, BufferBuilder buffer, int x, int y) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + 16), 100.0).func_187315_a(0.0, 0.0625).func_181675_d();
        buffer.func_181662_b((double)(x + 16), (double)(y + 16), 100.0).func_187315_a(0.0625, 0.0625).func_181675_d();
        buffer.func_181662_b((double)(x + 16), (double)y, 100.0).func_187315_a(0.0625, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 100.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

