/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.pool;

import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePool;
import github.kasuminova.stellarcore.common.pool.CanonicalizeTask;
import github.kasuminova.stellarcore.common.util.StellarLog;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class BakedQuadPool
extends AsyncCanonicalizePool<BakedQuad> {
    public static final BakedQuadPool INSTANCE = new BakedQuadPool();
    private final ObjectOpenCustomHashSet<BakedQuad> pool = new ObjectOpenCustomHashSet((Hash.Strategy)BakedQuadStrategy.access$000());

    private BakedQuadPool() {
    }

    public void canonicalizeAsync(Runnable task) {
        this.worker.offer(new CanonicalizeTask<BakedQuad>(() -> {
            task.run();
            return null;
        }, null));
    }

    @Override
    protected BakedQuad canonicalizeInternal(BakedQuad target) {
        return (BakedQuad)this.pool.addOrGet((Object)target);
    }

    @Override
    public void onClearPre() {
        StellarLog.LOG.info("[StellarCore-BakedQuadPool] {} BakedQuad processed. {} Unique, {} Deduplicated.", (Object)this.getProcessedCount(), (Object)this.pool.size(), (Object)(this.getProcessedCount() - (long)this.pool.size()));
    }

    @Override
    public void onClearPost() {
        StellarLog.LOG.info("[StellarCore-BakedQuadPool] Pool cleared.");
    }

    @Override
    protected void clearPool() {
        this.pool.clear();
        this.pool.trim();
    }

    @Override
    protected Set<BakedQuad> getPoolKeySet() {
        return this.pool;
    }

    @Override
    protected String getName() {
        return "BakedQuadPool";
    }

    private static class BakedQuadStrategy
    implements Hash.Strategy<BakedQuad> {
        private static final BakedQuadStrategy INSTANCE = new BakedQuadStrategy();

        private BakedQuadStrategy() {
        }

        public int hashCode(BakedQuad o) {
            int[] vertexData = o.func_178209_a();
            int tintIndex = o.func_178211_c();
            EnumFacing face = o.func_178210_d();
            TextureAtlasSprite sprite = o.func_187508_a();
            VertexFormat format = o.getFormat();
            boolean diffuseLighting = o.shouldApplyDiffuseLighting();
            return Objects.hash(Arrays.hashCode(vertexData), tintIndex, face, sprite, format, diffuseLighting);
        }

        public boolean equals(BakedQuad a, BakedQuad b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (!Arrays.equals(a.func_178209_a(), b.func_178209_a())) {
                return false;
            }
            if (a.func_178211_c() != b.func_178211_c()) {
                return false;
            }
            if (a.func_178210_d() != b.func_178210_d()) {
                return false;
            }
            if (a.shouldApplyDiffuseLighting() != b.shouldApplyDiffuseLighting()) {
                return false;
            }
            return a.func_187508_a().equals(b.func_187508_a());
        }

        static /* synthetic */ BakedQuadStrategy access$000() {
            return INSTANCE;
        }
    }
}

