/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.client.texture;

import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingIdentityHashMap;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import org.apache.commons.io.IOUtils;

public class SpriteBufferedImageCache {
    public static final SpriteBufferedImageCache INSTANCE = new SpriteBufferedImageCache();
    private final Map<TextureAtlasSprite, BufferedImage> cache = new NonBlockingIdentityHashMap<TextureAtlasSprite, BufferedImage>();
    private final Map<TextureAtlasSprite, int[]> rgbCache = new NonBlockingIdentityHashMap<TextureAtlasSprite, int[]>();
    private final Map<TextureAtlasSprite, IResource> resourceCache = new NonBlockingIdentityHashMap<TextureAtlasSprite, IResource>();

    public BufferedImage getImage(TextureAtlasSprite sprite) {
        return this.cache.get(sprite);
    }

    public int[] getRGBAndRemove(TextureAtlasSprite sprite) {
        return this.rgbCache.remove(sprite);
    }

    public IResource getResourceAndRemove(TextureAtlasSprite sprite) {
        return this.resourceCache.remove(sprite);
    }

    public void put(TextureAtlasSprite sprite, IResource resource) {
        this.resourceCache.put(sprite, resource);
    }

    public void put(TextureAtlasSprite sprite, BufferedImage image, int[] rgbArr) {
        this.cache.put(sprite, image);
        this.rgbCache.put(sprite, rgbArr);
    }

    public void clear() {
        this.cache.clear();
        this.rgbCache.clear();
        this.resourceCache.values().forEach(IOUtils::closeQuietly);
        this.resourceCache.clear();
    }
}

