/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.bugfix;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.ContainerTECache;
import github.kasuminova.stellarcore.common.util.StellarLog;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityContainerFixes {
    public static final TileEntityContainerFixes INSTANCE = new TileEntityContainerFixes();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!StellarCoreConfig.BUG_FIXES.container.containerTileEntityFixes) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        Container current = player.field_71070_bA;
        if (current == null) {
            return;
        }
        List<TileEntity> teList = ContainerTECache.getTileEntityList(current);
        for (TileEntity te : teList) {
            BlockPos pos = te.func_174877_v();
            World world = te.func_145831_w();
            if (!te.func_145837_r() && world != null && world.func_175667_e(pos) && world.func_175625_s(pos) == te) continue;
            player.func_71053_j();
            StellarLog.LOG.warn(String.format("Detected invalid TileEntity GUI, World: %s, Pos: %s, GUI Class: %s, TileEntity Class: %s", world == null ? "null" : world.func_72912_H().func_76065_j(), TileEntityContainerFixes.posToString((Vec3i)pos), current.getClass().getName(), te.getClass().getName()));
            break;
        }
    }

    public static String posToString(Vec3i pos) {
        return String.format("X:%s Y:%s Z:%s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

