/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.command;

import github.kasuminova.stellarcore.common.itemstack.ItemStackCapInitializer;
import github.kasuminova.stellarcore.common.mod.Mods;
import github.kasuminova.stellarcore.common.util.NumberUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandStellarCore
extends CommandBase {
    public static final CommandStellarCore INSTANCE = new CommandStellarCore();

    private CommandStellarCore() {
    }

    @Nonnull
    public String func_71517_b() {
        return "stellarcore";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandStellarCore.func_71530_a((String[])args, (String[])new String[]{"ItemStackCapInitStatus"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Usage: /stellarcore <ItemStackCapInitStatus>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        if (args.length == 1 && args[0].equals("ItemStackCapInitStatus")) {
            CommandStellarCore.printItemStackCapInitStatus(sender);
        }
    }

    protected static void printItemStackCapInitStatus(ICommandSender sender) {
        long existedMillis = ItemStackCapInitializer.getExistedMillis();
        long completedTasks = ItemStackCapInitializer.getCompletedTasks();
        int queueSize = ItemStackCapInitializer.getQueueSize();
        int maxQueueSize = ItemStackCapInitializer.getMaxQueueSize();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%s<Stellar%sCore>%s - ItemStack Cap Initializer Status:", Mods.RGB_CHAT.loaded() ? "#66CCFF-FF99CC" : TextFormatting.AQUA, Mods.RGB_CHAT.loaded() ? "" : TextFormatting.LIGHT_PURPLE, TextFormatting.RESET)));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Existed Time: %s%ss", TextFormatting.GREEN, TimeUnit.MILLISECONDS.toSeconds(existedMillis))));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Completed Tasks: %s%s", TextFormatting.GREEN, NumberUtils.formatDecimal(completedTasks))));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Workers: %s%s%s / %s%s", TextFormatting.GREEN, ItemStackCapInitializer.getWorkers(), TextFormatting.RESET, TextFormatting.YELLOW, ItemStackCapInitializer.getMaxWorkers())));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Queue Status: %s%s%s / %s%s%s (%s%s%s)", TextFormatting.YELLOW, NumberUtils.formatDecimal(queueSize), TextFormatting.RESET, TextFormatting.GOLD, NumberUtils.formatDecimal(maxQueueSize), TextFormatting.RESET, TextFormatting.YELLOW, NumberUtils.formatPercent(queueSize, maxQueueSize), TextFormatting.RESET)));
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Task Execution Per Second: %s%s/s", TextFormatting.AQUA, NumberUtils.formatDecimal(completedTasks > 0L ? (double)completedTasks / ((double)existedMillis / 1000.0) : (double)completedTasks))));
    }
}

