/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.config.category;

import net.minecraftforge.common.config.Config;

public class BugFixes {
    @Config.Name(value="Vanilla")
    public final Vanilla vanilla = new Vanilla();
    @Config.Name(value="Critical")
    public final Critical critical = new Critical();
    @Config.Name(value="Container")
    public final Container container = new Container();
    @Config.Name(value="AdvancedRocketry")
    public final AdvancedRocketry advancedRocketry = new AdvancedRocketry();
    @Config.Name(value="AncientSpellCraft")
    public final AncientSpellCraft ancientSpellCraft = new AncientSpellCraft();
    @Config.Name(value="ArmourersWorkshop")
    public final ArmourersWorkshop armourersWorkshop = new ArmourersWorkshop();
    @Config.Name(value="AstralSorcery")
    public final AstralSorcery astralSorcery = new AstralSorcery();
    @Config.Name(value="Avaritaddons")
    public final Avaritaddons avaritaddons = new Avaritaddons();
    @Config.Name(value="Botania")
    public final Botania botania = new Botania();
    @Config.Name(value="CoFHCore")
    public final CoFHCore coFHCore = new CoFHCore();
    @Config.Name(value="CustomStartingGear")
    public final CustomStartingGear customStartingGear = new CustomStartingGear();
    @Config.Name(value="DraconicEvolution")
    public final DraconicEvolution draconicEvolution = new DraconicEvolution();
    @Config.Name(value="EBWizardry")
    public final EBWizardry ebWizardry = new EBWizardry();
    @Config.Name(value="EnderIOConduits")
    public final EnderIOConduits enderIOConduits = new EnderIOConduits();
    @Config.Name(value="EnderUtilities")
    public final EnderUtilities enderUtilities = new EnderUtilities();
    @Config.Name(value="ExtraBotany")
    public final ExtraBotany extraBotany = new ExtraBotany();
    @Config.Name(value="FluxNetworks")
    public final FluxNetworks fluxNetworks = new FluxNetworks();
    @Config.Name(value="IndustrialCraft2")
    public final IndustrialCraft2 industrialCraft2 = new IndustrialCraft2();
    @Config.Name(value="InGameInfoXML")
    public final InGameInfoXML inGameInfoXML = new InGameInfoXML();
    @Config.Name(value="ImmersiveEngineering")
    public final ImmersiveEngineering immersiveEngineering = new ImmersiveEngineering();
    @Config.Name(value="JourneyMap")
    public final JourneyMap journeyMap = new JourneyMap();
    @Config.Name(value="LibVulpes")
    public final LibVulpes libVulpes = new LibVulpes();
    @Config.Name(value="Mekanism")
    public final Mekanism mekanism = new Mekanism();
    @Config.Name(value="ModularRouters")
    public final ModularRouters modularRouters = new ModularRouters();
    @Config.Name(value="MoreElectricTools")
    public final MoreElectricTools moreElectricTools = new MoreElectricTools();
    @Config.Name(value="MrCrayfishFurniture")
    public final MrCrayfishFurniture mrCrayfishFurniture = new MrCrayfishFurniture();
    @Config.Name(value="RPSIdeas")
    public final RPSIdeas rpsIdeas = new RPSIdeas();
    @Config.Name(value="ScalingGuis")
    public final ScalingGuis scalingGuis = new ScalingGuis();
    @Config.Name(value="Sync")
    public final Sync sync = new Sync();
    @Config.Name(value="TConEvo")
    public final TConEvo tConEvo = new TConEvo();
    @Config.Name(value="Techguns")
    public final Techguns techguns = new Techguns();
    @Config.Name(value="TheOneProbe")
    public final TheOneProbe theOneProbe = new TheOneProbe();
    @Config.Name(value="ThermalDynamics")
    public final ThermalDynamics thermalDynamics = new ThermalDynamics();
    @Config.Name(value="ThermalExpansion")
    public final ThermalExpansion thermalExpansion = new ThermalExpansion();

    public static class Vanilla {
        @Config.Comment(value={"Unlocks the size limit of NBT and removes the length limit of NBTTagCompound and NBTTagList,", "usually many mods will have this feature, you just need to enable one of these modules."})
        @Config.RequiresMcRestart
        @Config.Name(value="LongNBTKiller")
        public boolean longNBTKiller = false;
        @Config.Comment(value={"The maximum depth of NBTTagCompound and NBTTagList.", "It will only take effect if LongNBTKiller is enabled."})
        @Config.Name(value="MaxNBTDepth")
        public int maxNBTDepth = 2048;
        @Config.Comment(value={"The maximum size of NBT.", "It will only take effect if LongNBTKiller is enabled."})
        @Config.Name(value="MaxNBTSize")
        public int maxNBTSize = 0x1000000;
        @Config.Comment(value={"If the NBT size is larger than the maximum size, it will display a warning message.", "It will only take effect if LongNBTKiller is enabled."})
        @Config.Name(value="DisplayLargeNBTWarning")
        public boolean displayLargeNBTWarning = true;
        @Config.Comment(value={"Fix the NPE problem that occasionally occurs with the client when the server sends a null block packet."})
        @Config.Name(value="ClientNullBlockPacket")
        public boolean clientNullBlockPacket = true;
    }

    public static class Critical {
        @Config.Comment(value={"Usually just set it to true, this option fixed a serious network packet problem."})
        @Config.Name(value="GuGuUtilsSetContainerPacket")
        public boolean guguUtilsSetContainerPacket = true;
    }

    public static class Container {
        @Config.Comment(value={"A generic feature that when a player's open TileEntity GUI is uninstalled, ", "it also forces the player's open GUI to be closed."})
        @Config.Name(value="ContainerUnloadTileEntityFixes")
        public boolean containerTileEntityFixes = false;
        @Config.Comment(value={"Restricts the player from interacting with the world's blocks when the player opens any container interface (except the player inventory)."})
        @Config.Name(value="ContainerInteractRestriction")
        public boolean containerInteract = false;
    }

    public static class AdvancedRocketry {
        @Config.Comment(value={"Fix the NPE problem that occasionally occurs with BiomeChanger."})
        @Config.Name(value="ItemBiomeChanger")
        public boolean itemBiomeChanger = true;
        @Config.Comment(value={"When the planetDefs.xml file is corrupted, make it regenerate the file instead of letting it damn near crash.", "This is usually only a problem if the game process is unexpectedly exited, and the file is usually unrecoverable without a backup."})
        @Config.Name(value="PreventDimensionManagerCrash")
        public boolean dimensionManager = true;
    }

    public static class AncientSpellCraft {
        @Config.Comment(value={"(Client Only) Fix a memory leak caused by AncientSpellCraft's FakePlayer,", "mainly in that it would cause the first world loaded not to be cleaned up by Java GC.", "Experimental, if a crash occurs with anything related to ASFakePlayer, please report this issue immediately."})
        @Config.Name(value="ASFakePlayerFixes")
        public boolean asFakePlayer = false;
    }

    public static class ArmourersWorkshop {
        @Config.Comment(value={"Cleanroom only, used to fix an issue that caused the game to crash when unloading skin texture files."})
        @Config.Name(value="SkinTextureCrashFixes")
        public boolean skinTexture = true;
    }

    public static class AstralSorcery {
        @Config.Comment(value={"This option is used to fix occasional crashes related to PlayerAttributeMap."})
        @Config.RequiresWorldRestart
        @Config.Name(value="PlayerAttributeMapCrashFixes")
        public boolean playerAttributeMap = true;
        @Config.Comment(value={"This option is used to fix some item duplication issues on Astral Tome's constellation paper collection page."})
        @Config.Name(value="ContainerJournalFixes")
        public boolean containerJournal = true;
    }

    public static class Avaritaddons {
        @Config.Comment(value={"This option is used to fix some item duplication issues with Auto Extreme Crafting Table."})
        @Config.Name(value="TileEntityExtremeAutoCrafterFixes")
        public boolean tileEntityExtremeAutoCrafter = true;
    }

    public static class Botania {
        @Config.Comment(value={"(Client Only) Automatically clean up data when the player switches worlds, optional feature as WeakHashMap does not usually cause memory leaks."})
        @Config.Name(value="AutoCleanManaNetworkHandler")
        public boolean manaNetworkHandler = true;
    }

    public static class CoFHCore {
        @Config.Comment(value={"This option is used to fix some item duplication issues with any containers related to TE5."})
        @Config.Name(value="ContainerInventoryItemFixes")
        public boolean containerInventoryItem = true;
        @Config.Comment(value={"This option is used to fix an issue that would accidentally cause non-stackable items to", " exceed their maximum number of stacks."})
        @Config.Name(value="TileInventoryFixes")
        public boolean tileInventory = true;
    }

    public static class CustomStartingGear {
        @Config.Comment(value={"This option causes CustomStartingGear to standardize the encoding of file reads to UTF-8,", "preventing them from having problems on computers in certain regions."})
        @Config.Name(value="DataManagerCharSetFixes")
        public boolean dataManager = true;
    }

    public static class DraconicEvolution {
        @Config.Comment(value={"This option is used to fix some item duplication issues with CraftingInjector."})
        @Config.Name(value="CraftingInjectorFixes")
        public boolean craftingInjector = true;
    }

    public static class EBWizardry {
        @Config.Comment(value={"Fix an issue where Imbuement Altar could copy items using a special interact method."})
        @Config.Name(value="BlockImbuementAltarDupeFixes")
        public boolean blockImbuementAltar = true;
    }

    public static class EnderIOConduits {
        @Config.Comment(value={"A somewhat disruptive feature fix that modifies some of the way item conduits work,", "allowing some special cases to store extracted items inside the conduit,", "which will help fix some item duplication issues,", "but may introduce a slight performance overhead and some unexpected filter issues."})
        @Config.Name(value="ItemConduitItemStackCache")
        public boolean cachedItemConduit = false;
    }

    public static class EnderUtilities {
        @Config.Comment(value={"Fix an issue where HandyBag sometimes picking up items would cause them to be duplicated,", "with the side effect that the player's item bar would no longer be populated when picking up matching items."})
        @Config.Name(value="ItemHandyBagDupeFixes")
        public boolean itemHandyBag = true;
        @Config.Comment(value={"Fix an issue where Nullifier sometimes picking up items would cause them to be duplicated,", "with the side effect that the player's item bar would no longer be populated when picking up matching items."})
        @Config.Name(value="ItemNullifierDupeFixes")
        public boolean itemNullifier = true;
    }

    public static class ExtraBotany {
        @Config.Comment(value={"Prevents the Mana Liquefaction Device from storing far more liquid magic than it is set to store."})
        @Config.Name(value="TileManaLiquefactionFixes")
        public boolean tileManaLiquefaction = true;
    }

    public static class FluxNetworks {
        @Config.Comment(value={"Fixes an issue where TheOneProbe on a dedicated server shows localized text anomalies."})
        @Config.Name(value="TheOneProbeIntegration")
        public boolean fixTop = true;
        @Config.Comment(value={"Possible fix for duplicate users or even crashes on player networks in some cases."})
        @Config.Name(value="SynchronizeFixes")
        public boolean synchronize = true;
    }

    public static class IndustrialCraft2 {
        @Config.Comment(value={"Fixed an issue where some item repair recipes would duplication items."})
        @Config.Name(value="GradualRecipeFixes")
        public boolean gradualRecipe = true;
        @Config.Comment(value={"Fixed an issue where the orientation determined by Ejector / Pulling Upgrade was the opposite of what it actually was."})
        @Config.Name(value="StackUtilInvFacingFixes")
        public boolean stackUtilInvFacingFixes = true;
    }

    public static class InGameInfoXML {
        @Config.Comment(value={"Fix the issue where a paragraph would pop up to report an error in a server environment, that's all."})
        @Config.Name(value="PlayerHandlerFixes")
        public boolean playerHandler = true;
    }

    public static class ImmersiveEngineering {
        @Config.Comment(value={"Fixes an issue that would cause items to duplicate in certain special cases, although they were a bit tricky to reproduce."})
        @Config.Name(value="MultiblockStructureContainerFixes")
        public boolean blockIEMultiblock = true;
        @Config.Comment(value={"Fixes an issue that would cause fluids to duplicate in some special cases, although they were a bit tricky to reproduce."})
        @Config.Name(value="JerryCanFixes")
        public boolean fixJerryCanRecipe = true;
        @Config.Comment(value={"Makes Excavator not drop twice drops when digging blocks (possible side effect)."})
        @Config.Name(value="TileEntityExcavatorDigBlockFixes")
        public boolean tileEntityExcavator = true;
        @Config.Comment(value={"Fixes an issue that caused ArcFurnace's item bar items to stack", "more than their items themselves under certain special circumstances, helping to fix item duplication."})
        @Config.Name(value="TileEntityArcFurnaceInventoryFixes")
        public boolean tileEntityArcFurnace = true;
        @Config.Comment(value={"(Client Only) Clear the model cache when the player switches worlds to avoid memory leaks.", "Minor performance impact. Mainly a problem when installing with other mods."})
        @Config.Name(value="AutoCleanRenderCache")
        public boolean renderCache = true;
        @Config.Comment(value={"Immediately exit the thread when `Immersive Engineering Contributors Thread` encounters an error while reading JSON,", "instead of always printing the error."})
        @Config.Name(value="IEContributorsThreadExceptionFixes")
        public boolean contributorSpecialsDownloader = true;
    }

    public static class JourneyMap {
        @Config.Comment(value={"(Client Only) Automatically clears the radar player cache when a player switches worlds to avoid memory leaks caused in the client."})
        @Config.Name(value="AutoCleanPlayerRadar")
        public boolean playerRadar = true;
    }

    public static class LibVulpes {
        @Config.Comment(value={"(Client Only) Automatically clean up InputSyncHandler's spaceDown data when the player switches worlds.", "Although libvulpes has already coded this judgment, there is still a small chance that it will trigger a memory leak."})
        @Config.Name(value="AutoCleanInputSyncHandlerData")
        public boolean inputSyncHandler = true;
    }

    public static class Mekanism {
        @Config.Comment(value={"(Client Only) Automatically clean up old player data when the player switches worlds to address some memory leaks,", "and while Mekanism has written cleanup features, they will only clean up when returning to the main menu."})
        @Config.Name(value="AutoCleanPortableTeleports")
        public boolean portableTeleports = true;
    }

    public static class ModularRouters {
        @Config.Comment(value={"Prevent routers from recognizing fluid bucket containers to avoid unexpected fluid replication problems."})
        @Config.Name(value="BufferHandlerFluidHandlerFixes")
        public boolean bufferHandler = true;
    }

    public static class MoreElectricTools {
        @Config.Comment(value={"Items such as Electric First Aid Life Support do not continue to work if the player has died."})
        @Config.Name(value="LifeSupportsFixes")
        public boolean fixLifeSupports = true;
    }

    public static class MrCrayfishFurniture {
        @Config.Comment(value={"Stops the game from freezing in certain special cases, mainly occurring on photo frames and other similar blocks."})
        @Config.RequiresMcRestart
        @Config.Name(value="ImageCacheCrashFixes")
        public boolean imageCache = true;
        @Config.Comment(value={"Make blocks be rotated without losing their internal attributes and items (possibly not all blocks)."})
        @Config.Name(value="RotatableFurniture")
        public boolean rotatableFurniture = false;
        @Config.Comment(value={"Problem preventing certain container items from duplicate."})
        @Config.Name(value="BlockFurnitureTileFixes")
        public boolean blockFurnitureTile = true;
        @Config.Comment(value={"Stopping washing machines from repairing non-repairable items."})
        @Config.Name(value="WashingMachineDamageFixes")
        public boolean washingMachine = true;
    }

    public static class RPSIdeas {
        @Config.Comment(value={"(Client Only) Fix memory leaks caused by improper object management on the client side."})
        @Config.Name(value="ItemBioticSensorMemoryLeakFixes")
        public boolean itemBioticSensor = true;
    }

    public static class ScalingGuis {
        @Config.Comment(value={"Fixes an issue that caused a crash when deleting invalid GUI configurations."})
        @Config.Name(value="JsonHelperCrashFixes")
        public boolean fixJsonHelper = true;
    }

    public static class Sync {
        @Config.Comment(value={"A special fix that keeps Sync from triggering some weird item duplication issues when installed with Techguns."})
        @Config.Name(value="TechgunsDuplicationFixes")
        public boolean techgunsDuplicationFixes = true;
        @Config.Comment(value={"Make players get off their mounts when they die."})
        @Config.Name(value="RidingFixes")
        public boolean ridingFixes = true;
    }

    public static class TConEvo {
        @Config.Comment(value={"Fix a special crash issue that would cause special cases,", "reporting that they were attributed to xyz.phanta.tconevo.integration.avaritia.client.AvaritiaMaterialModel$BakedAvaritiaMaterialModel$ WithoutHalo handleCosmicLighting()."})
        @Config.Name(value="HandleCosmicLightingNPEFixes")
        public boolean handleCosmicLightingNPEFixes = true;
    }

    public static class Techguns {
        @Config.Comment(value={"Fixes an issue that would cause crashes in server environments."})
        @Config.Name(value="TGPermissionsCrashFixes")
        public boolean tgPermissions = true;
        @Config.Comment(value={"Fix for recipes not working properly for certain items (Techguns only)."})
        @Config.Name(value="InvalidRecipeFixes")
        public boolean fixAmmoSumRecipeFactory = true;
        @Config.Comment(value={"Fixes an issue that would cause crashes in server environments."})
        @Config.Name(value="ServerSideEntityCrashFixes")
        public boolean serverSideEntityCrashFixes = true;
    }

    public static class TheOneProbe {
        @Config.Comment(value={"Prevents TheOneProbe from rendering the entity/player in such a way that their head is locked to a fixed pitch."})
        @Config.Name(value="PlayerEntityRenderFixes")
        public boolean fixRenderHelper = true;
    }

    public static class ThermalDynamics {
        @Config.Comment(value={"Fix a fluid duplication issue where they would only appear on Super-Laminar FluidDuct."})
        @Config.Name(value="FluidDuplicateFixes")
        public boolean fixFluidDuplicate = true;
    }

    public static class ThermalExpansion {
        @Config.Comment(value={"The problem with stopping a backpack from replicating is that this probably does the same thing as UniversalTweaks."})
        @Config.Name(value="ContainerSatchelFilterFixes")
        public boolean containerSatchelFilter = true;
    }
}

