/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.itemstack;

import github.kasuminova.stellarcore.mixin.util.StellarItemStack;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.item.ItemStack;

public class ItemStackCapInitTask {
    private static final ThreadLocal<Deque<ItemStackCapInitTask>> JOINING_STACK = ThreadLocal.withInitial(ArrayDeque::new);
    private final StellarItemStack target;
    private boolean asyncComponentInitialized = false;
    private AtomicBoolean done;
    private AtomicBoolean joining;
    private ReentrantLock loadLock;
    private ReentrantLock joinLock;

    public ItemStackCapInitTask(ItemStack target) {
        this.target = (StellarItemStack)target;
    }

    void initAsyncComponents() {
        this.done = new AtomicBoolean(false);
        this.joining = new AtomicBoolean(false);
        this.loadLock = new ReentrantLock();
        this.joinLock = new ReentrantLock();
        this.asyncComponentInitialized = true;
    }

    public boolean tryRun() {
        if (this.acquireLoadLock()) {
            if (!this.done.get()) {
                this.run();
                this.done.set(true);
            }
            this.releaseLoadLock();
            return true;
        }
        return false;
    }

    public void run() {
        this.target.stellar_core$initCap();
    }

    public boolean isDone() {
        return this.done.get();
    }

    public boolean join() {
        Deque<ItemStackCapInitTask> taskStack = JOINING_STACK.get();
        if (taskStack.contains(this)) {
            return false;
        }
        taskStack.push(this);
        try {
            if (this.asyncComponentInitialized) {
                this.acquireJoinLock();
                if (this.tryRun()) {
                    this.target.stellar_core$joinCapInit();
                    this.releaseJoinLock();
                } else {
                    this.releaseJoinLock();
                    this.awaitLoadComplete();
                    this.target.stellar_core$joinCapInit();
                }
            } else {
                this.run();
            }
        }
        finally {
            taskStack.pop();
        }
        return true;
    }

    private void acquireJoinLock() {
        while (true) {
            this.awaitJoinComplete();
            if (!this.joinLock.tryLock()) continue;
            if (!this.joining.get()) break;
            this.joinLock.unlock();
        }
        this.joining.set(true);
        this.joinLock.unlock();
    }

    private void awaitJoinComplete() {
        while (this.joining.get()) {
            Thread.yield();
        }
    }

    private void releaseJoinLock() {
        this.joinLock.lock();
        this.joining.set(false);
        this.joinLock.unlock();
    }

    private boolean acquireLoadLock() {
        return this.loadLock.tryLock();
    }

    private void releaseLoadLock() {
        this.loadLock.unlock();
    }

    private void awaitLoadComplete() {
        while (this.loadLock.isLocked()) {
            Thread.yield();
        }
    }
}

