/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.itemstack;

import github.kasuminova.stellarcore.common.itemstack.ItemStackCapInitTask;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded.MpmcAtomicUnpaddedArrayQueue;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class ItemStackCapInitializer
implements Runnable {
    public static final ItemStackCapInitializer INSTANCE = new ItemStackCapInitializer();
    private static final ThreadLocal<Boolean> SHOULD_ADD_TASK = ThreadLocal.withInitial(() -> true);
    private static final int QUEUE_BOUND_SIZE = 50000;
    private static final int MAX_WORKERS = Math.min(StellarEnvironment.getConcurrency(), 8);
    private static final ThreadLocal<Long> PARKED_MICROS = ThreadLocal.withInitial(() -> 0L);
    private final Queue<ItemStackCapInitTask> taskQueue = ItemStackCapInitializer.createConcurrentQueue();
    private final AtomicLong completedTasks = new AtomicLong();
    private final AtomicInteger queueSize = new AtomicInteger();
    private final List<Thread> workers = new CopyOnWriteArrayList<Thread>();
    private long start = System.currentTimeMillis();
    private long completedTasksOffset = 0L;

    private ItemStackCapInitializer() {
        this.createWorkerInternal();
    }

    public static void setShouldAddTask(boolean shouldAddTask) {
        SHOULD_ADD_TASK.set(shouldAddTask);
    }

    public static void resetStatus() {
        ItemStackCapInitializer.INSTANCE.completedTasksOffset = -ItemStackCapInitializer.INSTANCE.completedTasks.get();
        ItemStackCapInitializer.INSTANCE.start = System.currentTimeMillis();
    }

    public static long getExistedMillis() {
        return System.currentTimeMillis() - ItemStackCapInitializer.INSTANCE.start;
    }

    public static long getCompletedTasks() {
        return ItemStackCapInitializer.INSTANCE.completedTasks.get() + ItemStackCapInitializer.INSTANCE.completedTasksOffset;
    }

    public static int getQueueSize() {
        return ItemStackCapInitializer.INSTANCE.queueSize.get();
    }

    public static int getMaxQueueSize() {
        return MAX_WORKERS * 50000;
    }

    public static int getWorkers() {
        return ItemStackCapInitializer.INSTANCE.workers.size();
    }

    public static int getMaxWorkers() {
        return MAX_WORKERS;
    }

    private synchronized void createWorker() {
        int workers;
        int tasks = this.queueSize.get();
        if (tasks < 50000 * (workers = this.workers.size()) || workers > MAX_WORKERS) {
            return;
        }
        StellarLog.LOG.warn("[StellarCore-ItemStackCapInitializer] Creating new worker because queue size reached bound size (limit {}).", (Object)(50000 * workers));
        this.createWorkerInternal();
    }

    private void createWorkerInternal() {
        Thread worker = new Thread((Runnable)this, "StellarCore-ItemStackCapInitializer-" + this.workers.size());
        worker.start();
        worker.setPriority(6);
        this.workers.add(worker);
    }

    public void addTask(ItemStackCapInitTask task) {
        if (!SHOULD_ADD_TASK.get().booleanValue()) {
            return;
        }
        task.initAsyncComponents();
        while (!this.taskQueue.offer(task) && !this.taskQueue.offer(task)) {
        }
        int tasks = this.queueSize.incrementAndGet();
        int workers = this.workers.size();
        if (workers > 0 && tasks > 50000 * workers && workers < MAX_WORKERS) {
            this.createWorker();
        }
    }

    @Override
    public void run() {
        StellarLog.LOG.info("[StellarCore] {} started.", (Object)Thread.currentThread().getName());
        while (!Thread.currentThread().isInterrupted()) {
            boolean executed = false;
            try {
                ItemStackCapInitTask task;
                int completed = 0;
                while ((task = this.pollTask()) != null) {
                    task.tryRun();
                    executed = true;
                    ++completed;
                    this.queueSize.decrementAndGet();
                }
                this.completedTasks.addAndGet(completed);
            }
            catch (Throwable e) {
                StellarLog.LOG.error("[StellarCore] ItemStackCapInitializer failed to execute task.", e);
            }
            if (executed) {
                PARKED_MICROS.set(0L);
            }
            ItemStackCapInitializer.park();
        }
        StellarLog.LOG.warn("[StellarCore] {} stopped, it may be invalid.", (Object)Thread.currentThread().getName());
    }

    private ItemStackCapInitTask pollTask() {
        return this.taskQueue.poll();
    }

    private static void park() {
        long parkedMicros = PARKED_MICROS.get();
        if (parkedMicros > 100000L) {
            LockSupport.parkNanos(500000L);
            PARKED_MICROS.set(parkedMicros + 500L);
        } else if (parkedMicros > 50000L) {
            LockSupport.parkNanos(100000L);
            PARKED_MICROS.set(parkedMicros + 100L);
        } else if (parkedMicros > 10000L) {
            LockSupport.parkNanos(10000L);
            PARKED_MICROS.set(parkedMicros + 10L);
        } else {
            LockSupport.parkNanos(5000L);
            PARKED_MICROS.set(parkedMicros + 5L);
        }
    }

    private static <E> Queue<E> createConcurrentQueue() {
        return new MpmcAtomicUnpaddedArrayQueue(50000 * (MAX_WORKERS + 1));
    }
}

