/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.pool;

import github.kasuminova.stellarcore.common.pool.CanonicalizeTask;
import github.kasuminova.stellarcore.common.pool.DeferredCanonicalizable;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.MpscUnboundedArrayQueue;
import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.locks.LockSupport;

public class CanonicalizeWorker<T>
implements Runnable {
    private final Queue<WeakReference<DeferredCanonicalizable<T>>> deferedQueue = CanonicalizeWorker.createConcurrentQueue();
    private final Queue<CanonicalizeTask<T>> queue = CanonicalizeWorker.createConcurrentQueue();
    private final String name;
    private volatile Thread worker = null;
    private long parkedMillis = 0L;

    public CanonicalizeWorker(String name) {
        this.name = name;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.stop();
        this.worker = new Thread((Runnable)this, "StellarCore-" + this.name + "-CanonicalizeWorker");
        this.worker.start();
    }

    public void stop() {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
    }

    public boolean isRunning() {
        return this.worker != null && this.worker.isAlive();
    }

    public Thread getThread() {
        return this.worker;
    }

    public void offer(CanonicalizeTask<T> task) {
        this.queue.offer(task);
    }

    public void defer(DeferredCanonicalizable<T> canonicalizable) {
        this.deferedQueue.offer(new WeakReference<DeferredCanonicalizable<T>>(canonicalizable));
    }

    @Override
    public void run() {
        StellarLog.LOG.info("[StellarCore-{}] CanonicalizeWorker started.", (Object)this.name);
        while (!Thread.currentThread().isInterrupted()) {
            CanonicalizeTask<T> task;
            WeakReference<DeferredCanonicalizable<T>> ref;
            while ((ref = this.deferedQueue.poll()) != null) {
                DeferredCanonicalizable canonicalizable = (DeferredCanonicalizable)ref.get();
                if (canonicalizable == null) continue;
                canonicalizable.canonicalizeAsync();
            }
            boolean executed = false;
            while ((task = this.queue.poll()) != null) {
                task.execute();
                executed = true;
            }
            if (executed) {
                this.parkedMillis = 0L;
            }
            this.park();
        }
        StellarLog.LOG.info("[StellarCore-{}] CanonicalizeWorker stopped.", (Object)this.name);
    }

    private void park() {
        if (this.parkedMillis > 10000L) {
            LockSupport.parkNanos(100000000L);
            this.parkedMillis += 100L;
        } else if (this.parkedMillis > 1000L) {
            LockSupport.parkNanos(10000000L);
            this.parkedMillis += 10L;
        } else {
            LockSupport.parkNanos(1000000L);
            ++this.parkedMillis;
        }
    }

    private static <E> Queue<E> createConcurrentQueue() {
        return new MpscUnboundedArrayQueue(10000);
    }
}

