/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.pool;

import github.kasuminova.stellarcore.common.pool.AsyncCanonicalizePoolBase;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import javax.annotation.Nullable;

public class StringPool
extends AsyncCanonicalizePoolBase<String> {
    public static final StringPool INSTANCE = new StringPool();
    private final ObjectOpenHashSet<String> pool = new ObjectOpenHashSet();
    private volatile long processedCount = 0L;

    private StringPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String canonicalize(@Nullable String target) {
        if (target == null) {
            return null;
        }
        ObjectOpenHashSet<String> objectOpenHashSet = this.pool;
        synchronized (objectOpenHashSet) {
            ++this.processedCount;
            return (String)this.pool.addOrGet((Object)target);
        }
    }

    @Override
    public long getProcessedCount() {
        return this.processedCount;
    }

    @Override
    public int getUniqueCount() {
        return this.pool.size();
    }

    @Override
    protected String getName() {
        return "StringPool";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ObjectOpenHashSet<String> objectOpenHashSet = this.pool;
        synchronized (objectOpenHashSet) {
            this.processedCount = 0L;
            this.pool.clear();
        }
    }
}

