/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.common.util;

import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class HashedItemStack {
    private final ItemStack stack;
    private final int stackHashCode;
    private final int damage;
    private final boolean hasTag;

    public HashedItemStack(ItemStack stack, int stackHashCode, int damage, boolean hasTag) {
        this.stack = stack;
        this.stackHashCode = stackHashCode;
        this.damage = damage;
        this.hasTag = hasTag;
    }

    public static HashedItemStack ofTag(ItemStack stack) {
        ItemStack copied = stack.func_77946_l();
        return HashedItemStack.ofTagUnsafe(copied);
    }

    public static HashedItemStack ofTagUnsafe(ItemStack stack) {
        int hash;
        int damage;
        boolean hasTag;
        NBTTagCompound tag = stack.func_77978_p();
        boolean bl = hasTag = tag != null && !tag.func_82582_d();
        int n = stack.func_77984_f() ? stack.func_77952_i() : (damage = stack.func_77981_g() ? stack.func_77960_j() : 0);
        if (hasTag) {
            int combinedHashCode = Long.hashCode((long)System.identityHashCode(stack.func_77973_b()) & 0xFFFFFFFFL | ((long)damage & 0xFFFFFFFFL) << 32);
            int tagHashCode = tag.hashCode();
            hash = tagHashCode != 0 ? combinedHashCode ^ tagHashCode : combinedHashCode;
        } else {
            hash = Long.hashCode((long)System.identityHashCode(stack.func_77973_b()) & 0xFFFFFFFFL | ((long)damage & 0xFFFFFFFFL) << 32);
        }
        return new HashedItemStack(stack, hash, damage, hasTag);
    }

    public static HashedItemStack ofMeta(ItemStack stack) {
        ItemStack copied = stack.func_77946_l();
        return HashedItemStack.ofMetaUnsafe(copied);
    }

    public static HashedItemStack ofMetaUnsafe(ItemStack stack) {
        int damage = stack.func_77984_f() ? stack.func_77952_i() : (stack.func_77981_g() ? stack.func_77960_j() : 0);
        int hash = Long.hashCode((long)System.identityHashCode(stack.func_77973_b()) & 0xFFFFFFFFL | ((long)damage & 0xFFFFFFFFL) << 32);
        return new HashedItemStack(stack, hash, damage, false);
    }

    public static String stackToString(ItemStack stack) {
        String stackTagStr = null;
        String registryName = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString();
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && !tag.func_82582_d()) {
            stackTagStr = tag.toString();
        }
        return HashedItemStack.strToBase64(registryName) + "_" + stack.func_77952_i() + (stackTagStr == null ? "" : "_" + HashedItemStack.strToBase64(stackTagStr));
    }

    public static String strToBase64(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    public boolean equals(Object o) {
        if (o instanceof HashedItemStack) {
            HashedItemStack hashedItemStack = (HashedItemStack)o;
            if (this.hasTag && !hashedItemStack.hasTag) {
                return false;
            }
            return HashedItemStack.stackEqualsNonNBT(this.stack, hashedItemStack.stack, this.damage, hashedItemStack.damage) && (!this.hasTag || ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)hashedItemStack.stack));
        }
        return false;
    }

    public static boolean stackEqualsNonNBT(@Nonnull ItemStack stack, @Nonnull ItemStack other, int stackDamage, int otherDamage) {
        if (stack.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        Item sItem = stack.func_77973_b();
        Item oItem = other.func_77973_b();
        if (sItem.func_77614_k() || oItem.func_77614_k()) {
            return sItem == oItem && (stackDamage == otherDamage || stackDamage == Short.MAX_VALUE || otherDamage == Short.MAX_VALUE);
        }
        return sItem == oItem;
    }

    public HashedItemStack copy() {
        return new HashedItemStack(this.stack.func_77946_l(), this.stackHashCode, this.damage, this.hasTag);
    }

    public HashedItemStack copyWithSize(int size) {
        ItemStack copied = this.stack.func_77946_l();
        copied.func_190920_e(size);
        return new HashedItemStack(copied, this.stackHashCode, this.damage, this.hasTag);
    }

    public int hashCode() {
        return this.stackHashCode;
    }

    public String toString() {
        return "HashedItemStack[" + "stack=" + this.stack + "," + "stackHashCode=" + this.stackHashCode + "," + "damage=" + this.damage + "," + "hasTag=" + this.hasTag + "]";
    }

    public ItemStack stack() {
        return this.stack;
    }

    public int stackHashCode() {
        return this.stackHashCode;
    }

    public int damage() {
        return this.damage;
    }

    public boolean hasTag() {
        return this.hasTag;
    }
}

