/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.cfm;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.client.ImageCache;
import com.mrcrayfish.furniture.client.Texture;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ImageCache.class})
public abstract class MixinImageCache {
    @Shadow(remap=false)
    private Map<String, Texture> cacheMap;

    @Shadow(remap=false)
    public abstract File getCache();

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void overwriteInit(CallbackInfo ci) {
        this.cacheMap = new NonBlockingHashMap<String, Texture>();
    }

    @Overwrite(remap=false)
    public boolean loadCached(String url) {
        if (this.cacheMap.containsKey(url)) {
            return true;
        }
        String id = DigestUtils.sha1Hex((byte[])url.getBytes());
        File file = new File(this.getCache(), id);
        if (file.exists()) {
            this.add(url, file);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    @Nullable
    public Texture get(String url) {
        if (url == null) {
            return null;
        }
        Texture texture = this.cacheMap.get(url);
        if (texture != null) {
            return texture;
        }
        MixinImageCache mixinImageCache = this;
        synchronized (mixinImageCache) {
            return this.cacheMap.get(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public void add(String url, File file) {
        if (this.cacheMap.containsKey(url)) {
            return;
        }
        MixinImageCache mixinImageCache = this;
        synchronized (mixinImageCache) {
            if (!this.cacheMap.containsKey(url)) {
                Texture texture = new Texture(file);
                this.cacheMap.put(url, texture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public boolean add(String url, byte[] data) {
        Texture texture;
        if (this.cacheMap.containsKey(url)) {
            return true;
        }
        String id = DigestUtils.sha1Hex((byte[])url.getBytes());
        File image = new File(this.getCache(), id);
        MixinImageCache mixinImageCache = this;
        synchronized (mixinImageCache) {
            if (this.cacheMap.containsKey(url)) {
                return true;
            }
            texture = new Texture(image);
            this.cacheMap.put(url, texture);
        }
        try {
            FileUtils.writeByteArrayToFile((File)image, (byte[])data);
        }
        catch (IOException e) {
            MrCrayfishFurnitureMod.logger().warn((Object)e);
        }
        Minecraft.func_71410_x().func_152344_a(() -> ((Texture)texture).update());
        return true;
    }

    @Overwrite(remap=false)
    private void tick() {
        this.cacheMap.values().forEach(Texture::update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public boolean isCached(String url) {
        if (this.cacheMap.containsKey(url)) {
            return true;
        }
        MixinImageCache mixinImageCache = this;
        synchronized (mixinImageCache) {
            return this.cacheMap.containsKey(url);
        }
    }
}

