/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.chisel;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.HashedItemStack;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.block.TileAutoChisel;

@Mixin(value={TileAutoChisel.class})
public class MixinTileAutoChisel {
    @Unique
    private static final Map<HashedItemStack, ICarvingGroup> CACHED_CARVING_GROUP = new WeakHashMap<HashedItemStack, ICarvingGroup>();
    @Unique
    private static final Map<HashedItemStack, ICarvingVariation> CACHED_VARIATION_GROUP = new WeakHashMap<HashedItemStack, ICarvingVariation>();
    @Unique
    private long stellar_core$interval = 20L;

    @ModifyConstant(method={"update"}, constant={@Constant(longValue=20L)})
    private long modifyUpdateInterval(long interval) {
        if (!StellarCoreConfig.PERFORMANCE.chisel.autoChiselImprovements) {
            return interval;
        }
        return this.stellar_core$interval;
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lteam/chisel/api/carving/ICarvingRegistry;getGroup(Lnet/minecraft/item/ItemStack;)Lteam/chisel/api/carving/ICarvingGroup;", remap=false))
    private ICarvingGroup redirectGetGroup(ICarvingRegistry instance, ItemStack stack) {
        if (!StellarCoreConfig.PERFORMANCE.chisel.autoChiselImprovements) {
            return instance.getGroup(stack);
        }
        HashedItemStack hashed = HashedItemStack.ofTagUnsafe(stack);
        ICarvingGroup group = CACHED_CARVING_GROUP.get(hashed);
        if (group != null) {
            return group;
        }
        group = instance.getGroup(stack);
        CACHED_CARVING_GROUP.put(HashedItemStack.ofTag(stack), group);
        return group;
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lteam/chisel/api/carving/ICarvingRegistry;getVariation(Lnet/minecraft/item/ItemStack;)Lteam/chisel/api/carving/ICarvingVariation;", remap=false))
    private ICarvingVariation redirectGetVariation(ICarvingRegistry instance, ItemStack stack) {
        if (!StellarCoreConfig.PERFORMANCE.chisel.autoChiselImprovements) {
            return instance.getVariation(stack);
        }
        HashedItemStack hashed = HashedItemStack.ofTagUnsafe(stack);
        ICarvingVariation variation = CACHED_VARIATION_GROUP.get(hashed);
        if (variation != null) {
            return variation;
        }
        variation = instance.getVariation(stack);
        CACHED_VARIATION_GROUP.put(HashedItemStack.ofTag(stack), variation);
        return variation;
    }

    @Inject(method={"mergeOutput"}, at={@At(value="HEAD")}, remap=false)
    private void injectMergeOutput(ItemStack stack, CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.chisel.autoChiselImprovements) {
            return;
        }
        this.stellar_core$interval = Math.max(this.stellar_core$interval - 5L, 20L);
    }

    @Inject(method={"setSourceSlot"}, at={@At(value="HEAD")}, remap=false)
    private void injectSetSourceSlot(int slot, CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.chisel.autoChiselImprovements) {
            return;
        }
        if (slot == -1) {
            int maxWorkDelay = StellarCoreConfig.PERFORMANCE.chisel.autoChiselMaxWorkDelay;
            this.stellar_core$interval = Math.min(this.stellar_core$interval + 5L, (long)maxWorkDelay);
        }
    }
}

