/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.draconicevolution;

import com.brandon3055.brandonscore.lib.PairXZ;
import com.brandon3055.brandonscore.registry.ModFeatureParser;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.world.ChaosWorldGenHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={ChaosWorldGenHandler.class})
public class MixinChaosWorldGenHandler {
    @Overwrite(remap=false)
    public static void generateChunk(World world, int chunkX, int chunkZ, PairXZ<Integer, Integer> islandCenter, Random random) {
        PairXZ closestSpawn;
        PairXZ pairXZ = closestSpawn = islandCenter == null ? ChaosWorldGenHandler.getClosestChaosSpawn((int)chunkX, (int)chunkZ) : islandCenter;
        if ((Integer)closestSpawn.x == 0 && (Integer)closestSpawn.z == 0) {
            return;
        }
        int posX = chunkX * 16;
        int posZ = chunkZ * 16;
        int copyStartDistance = 180;
        if (Math.abs(posX - (Integer)closestSpawn.x) > copyStartDistance || Math.abs(posZ - (Integer)closestSpawn.z) > copyStartDistance) {
            return;
        }
        if ((Integer)closestSpawn.x > posX && (Integer)closestSpawn.x <= posX + 16 && (Integer)closestSpawn.z > posZ && (Integer)closestSpawn.z <= posZ + 16) {
            MixinChaosWorldGenHandler.generateStructures(world, (PairXZ<Integer, Integer>)closestSpawn, random);
        }
        if (!DEConfig.chaosIslandVoidMode) {
            for (int trueX = posX; trueX < posX + 16; ++trueX) {
                for (int y = 0; y < 255; ++y) {
                    for (int trueZ = posZ; trueZ < posZ + 16; ++trueZ) {
                        double plateauFalloff;
                        int x = trueX - (Integer)closestSpawn.x;
                        int z = trueZ - (Integer)closestSpawn.z;
                        int size = 80;
                        double dist = Math.sqrt(x * x + (y - 16) * (y - 16) + z * z);
                        double xd = (double)x / (double)size;
                        double yd = (double)y / 32.0;
                        double zd = (double)z / (double)size;
                        double centerFalloff = 1.0 / (dist * 0.05);
                        if (centerFalloff < 0.0) {
                            centerFalloff = 0.0;
                        }
                        if ((plateauFalloff = yd < 0.4 ? yd * 2.5 : (yd <= 0.6 ? 1.0 : (yd > 0.6 && yd < 1.0 ? 1.0 - (yd - 0.6) * 2.5 : 0.0))) == 0.0 || centerFalloff == 0.0) continue;
                        double heightMapFalloff = 0.0;
                        for (int octave = 1; octave < 5; ++octave) {
                            heightMapFalloff += (SimplexNoise.noise((double)(xd * (double)octave + (double)((Integer)closestSpawn.x).intValue()), (double)(zd * (double)octave + (double)((Integer)closestSpawn.z).intValue())) + 1.0) * 0.5 * 0.01 * ((double)octave * 10.0 * 1.0 - dist * 0.001);
                        }
                        if (heightMapFalloff <= 0.0) {
                            heightMapFalloff = 0.0;
                        }
                        if ((heightMapFalloff += (0.5 - Math.abs(yd - 0.5)) * 0.15) == 0.0) continue;
                        double density = centerFalloff * plateauFalloff * heightMapFalloff;
                        BlockPos pos = new BlockPos(x + (Integer)closestSpawn.x, y + 64 + DEConfig.chaosIslandYOffset, z + (Integer)closestSpawn.z);
                        if (!(density > 0.1) || !world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() == DEFeatures.chaosShardAtmos) continue;
                        world.func_175656_a(pos, dist > 60.0 || dist > (double)random.nextInt(60) ? Blocks.field_150377_bs.func_176223_P() : Blocks.field_150343_Z.func_176223_P());
                    }
                }
            }
        }
    }

    @Overwrite(remap=false)
    public static void generateStructures(World world, PairXZ<Integer, Integer> islandCenter, Random random) {
        int outerRadius = 330;
        int shardY = 80 + DEConfig.chaosIslandYOffset;
        int coreHeight = 10;
        int coreWidth = 20;
        for (int y = shardY - coreHeight; y <= shardY + coreHeight; ++y) {
            int h = Math.abs(y - shardY);
            int inRadius = h - 3;
            double yp = (double)(coreHeight - h) / (double)coreHeight;
            int outRadius = (int)(yp * (double)coreWidth);
            outRadius -= outRadius * outRadius / 100;
            MixinChaosWorldGenHandler.genCoreSlice(world, (Integer)islandCenter.x, y, (Integer)islandCenter.z, inRadius, shardY, coreWidth, true, random);
            MixinChaosWorldGenHandler.genCoreSlice(world, (Integer)islandCenter.x, y, (Integer)islandCenter.z, outRadius, shardY, coreWidth, false, random);
        }
        BlockPos center = new BlockPos(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue());
        if (ModFeatureParser.isEnabled((Object)DEFeatures.chaosCrystal)) {
            world.func_175656_a(center, DEFeatures.chaosCrystal.func_176223_P());
            TileChaosCrystal tileChaosShard = (TileChaosCrystal)world.func_175625_s(center);
            tileChaosShard.setLockPos();
        }
    }

    @Overwrite(remap=false)
    public static void genCoreSlice(World world, int xi, int yi, int zi, int ringRadius, int yc, int coreRadious, boolean fillIn, Random rand) {
        if (DEConfig.chaosIslandVoidMode) {
            return;
        }
        for (int x = xi - coreRadious; x <= xi + coreRadious; ++x) {
            for (int z = zi - coreRadious; z <= zi + coreRadious; ++z) {
                Block b;
                double oRad;
                double dist = Utils.getDistanceAtoB((double)x, (double)yi, (double)z, (double)xi, (double)yc, (double)zi);
                if (dist > (oRad = (double)(coreRadious - Math.abs(yc - yi) * Math.abs(yc - yi) / 10)) - 3.0 && rand.nextDouble() * 3.0 < dist - (oRad - 3.0)) continue;
                if (fillIn && (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) <= ringRadius) {
                    if ((int)dist < 9) {
                        world.func_175656_a(new BlockPos(x, yi, z), DEFeatures.infusedObsidian.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(new BlockPos(x, yi, z), Blocks.field_150343_Z.func_176223_P());
                    continue;
                }
                if (!fillIn && (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) >= ringRadius) {
                    world.func_175656_a(new BlockPos(x, yi, z), Blocks.field_150343_Z.func_176223_P());
                    continue;
                }
                if (fillIn || (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) > ringRadius || (b = world.func_180495_p(new BlockPos(x, yi, z)).func_177230_c()) != Blocks.field_150350_a && b != Blocks.field_150377_bs && b != Blocks.field_150343_Z) continue;
                world.func_175656_a(new BlockPos(x, yi, z), DEFeatures.chaosShardAtmos.func_176223_P());
            }
        }
    }
}

