/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.draconicevolution;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TileChaosCrystal.class})
public abstract class MixinTileChaosCrystal
extends TileBCBase
implements ITickable {
    @Shadow(remap=false)
    public int tick;
    @Final
    @Shadow(remap=false)
    private ManagedLong posLock;
    @Final
    @Shadow(remap=false)
    private ManagedInt dimLock;
    @Final
    @Shadow(remap=false)
    public ManagedBool guardianDefeated;
    @Shadow(remap=false)
    boolean validateOldHash;
    @Shadow(remap=false)
    int oldhash;
    @Shadow(remap=false)
    private int soundTimer;
    @Unique
    public boolean isChunkGenerated = false;
    @Unique
    public boolean isChunkGeneratedOK = false;
    @Unique
    public boolean SummoningDragon = false;
    @Unique
    public boolean checkRangePlayer = false;
    @Unique
    public boolean SummoningPillars = false;
    @Unique
    private int respawnStateTicks;
    @Unique
    private List<BlockPos> crystalSpawnList;
    @Unique
    private List<BlockPos> crystalsPosCache;

    @Overwrite(remap=false)
    public void setLockPos() {
        this.posLock.value = this.field_174879_c.func_177986_g();
        this.dimLock.value = this.field_145850_b.field_73011_w.getDimension();
        this.isChunkGenerated = true;
    }

    @Overwrite(remap=false)
    public void func_73660_a() {
        ++this.tick;
        if (this.validateOldHash) {
            int hash = (this.field_174879_c.toString() + String.valueOf(this.field_145850_b.field_73011_w.getDimension())).hashCode();
            if (hash == this.oldhash) {
                this.setLockPos();
            } else {
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
            this.validateOldHash = false;
        }
        if (this.isChunkGenerated && !this.isChunkGeneratedOK) {
            this.isChunkGeneratedOK = true;
        }
        if (this.tick > 1 && !this.field_145850_b.field_72995_K && this.hasBeenMoved()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (this.field_145850_b.field_72995_K && this.soundTimer-- <= 0) {
            this.soundTimer = 3600 + this.field_145850_b.field_73012_v.nextInt(1200);
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, DESoundHandler.chaosChamberAmbient, SoundCategory.AMBIENT, 1.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f, false);
        }
        if (!this.field_145850_b.field_72995_K && this.guardianDefeated.value && this.field_145850_b.field_73012_v.nextInt(50) == 0) {
            int x = 5 - this.field_145850_b.field_73012_v.nextInt(11);
            int z = 5 - this.field_145850_b.field_73012_v.nextInt(11);
            EntityLightningBolt bolt = new EntityLightningBolt(this.field_145850_b, (double)(this.field_174879_c.func_177958_n() + x), (double)this.field_145850_b.func_175672_r(this.field_174879_c.func_177982_a(x, 0, z)).func_177956_o(), (double)(this.field_174879_c.func_177952_p() + z), false);
            bolt.field_70158_ak = true;
            this.field_145850_b.func_72942_c((Entity)bolt);
        }
        if (!this.field_145850_b.field_72995_K && this.isChunkGeneratedOK) {
            if (this.tick % 20 == 0 && !this.checkRangePlayer) {
                this.isCheckRangePlayer();
            }
            if (this.checkRangePlayer && !this.SummoningPillars) {
                this.isSummoningPillars();
            }
            if (this.SummoningPillars && !this.SummoningDragon) {
                EntityChaosGuardian guardian = new EntityChaosGuardian(this.field_145850_b);
                guardian.func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                guardian.homeY = this.func_174877_v().func_177956_o();
                this.field_145850_b.func_72838_d((Entity)guardian);
                this.SummoningDragon = true;
            }
        }
    }

    @Unique
    public void isCheckRangePlayer() {
        BlockPos pos1 = new BlockPos(this.func_174877_v().func_177981_b(15).func_177958_n() + 15, this.func_174877_v().func_177981_b(15).func_177956_o() + 15, this.func_174877_v().func_177981_b(15).func_177952_p() + 15);
        BlockPos pos2 = new BlockPos(this.func_174877_v().func_177979_c(15).func_177958_n() - 15, this.func_174877_v().func_177979_c(15).func_177956_o() - 15, this.func_174877_v().func_177979_c(15).func_177952_p() - 15);
        AxisAlignedBB entitys = new AxisAlignedBB(pos1, pos2);
        List entitiesToDie = this.func_145831_w().func_72872_a(Entity.class, entitys);
        for (Entity entity : entitiesToDie) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            if (!(this.field_174879_c.func_177981_b(15).func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 225.0)) continue;
            this.checkRangePlayer = true;
            break;
        }
    }

    @Unique
    public void isSummoningPillars() {
        int i;
        boolean spawn;
        int spawnRate = 15;
        boolean bl = spawn = (i = this.respawnStateTicks++) % spawnRate == 0;
        if (spawn) {
            BlockPos nextSpawn = this.getNextCrystalPos(i == 0);
            if (nextSpawn != null) {
                for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)nextSpawn.func_177982_a(-10, -10, -10), (BlockPos)nextSpawn.func_177982_a(10, 10, 10))) {
                    this.field_145850_b.func_175698_g(blockpos);
                }
                MixinTileChaosCrystal.generateObelisk(this.field_145850_b, nextSpawn, this.field_145850_b.field_73012_v);
                this.field_145850_b.func_175656_a(nextSpawn, DEFeatures.infusedObsidian.func_176223_P());
                EntityGuardianCrystal crystal = new EntityGuardianCrystal(this.field_145850_b);
                crystal.func_70107_b((double)nextSpawn.func_177958_n() + 0.5, (double)(nextSpawn.func_177956_o() + 1), (double)nextSpawn.func_177952_p() + 0.5);
                this.field_145850_b.func_72838_d((Entity)crystal);
            } else {
                this.SummoningPillars = true;
            }
        }
    }

    @Unique
    public List<BlockPos> getCrystalPositions() {
        if (this.crystalsPosCache == null) {
            int sZ;
            int sX;
            double rotation;
            int i;
            this.crystalsPosCache = new ArrayList<BlockPos>();
            for (i = 0; i < 7; ++i) {
                rotation = (double)i * 0.9;
                sX = this.func_174877_v().func_177958_n() + (int)(Math.sin(rotation) * 45.0);
                sZ = this.func_174877_v().func_177952_p() + (int)(Math.cos(rotation) * 45.0);
                this.crystalsPosCache.add(new BlockPos(sX, this.func_174877_v().func_177956_o() + 40, sZ));
            }
            for (i = 0; i < 14; ++i) {
                rotation = (double)i * 0.45;
                sX = this.func_174877_v().func_177958_n() + (int)(Math.sin(rotation) * 90.0);
                sZ = this.func_174877_v().func_177952_p() + (int)(Math.cos(rotation) * 90.0);
                this.crystalsPosCache.add(new BlockPos(sX, this.func_174877_v().func_177956_o() + 45, sZ));
            }
        }
        return this.crystalsPosCache;
    }

    @Unique
    public BlockPos getNextCrystalPos(boolean initial) {
        if (initial) {
            this.crystalSpawnList = new ArrayList<BlockPos>(this.getCrystalPositions());
        }
        if (this.crystalSpawnList.isEmpty()) {
            return null;
        }
        return this.crystalSpawnList.remove(0);
    }

    @Unique
    private static void generateObelisk(World world, BlockPos genPos, Random rand) {
        for (int i = 0; i < 20; i += 3) {
            EntityLightningBolt entity = new EntityLightningBolt(world, (double)(genPos.func_177958_n() - 2 + rand.nextInt(5)), (double)(genPos.func_177956_o() - rand.nextInt(20)), (double)(genPos.func_177952_p() - 2 + rand.nextInt(5)), false);
            world.func_72942_c((Entity)entity);
        }
        if (DEConfig.chaosIslandVoidMode) {
            return;
        }
        int r = 3;
        BlockPos.func_177980_a((BlockPos)genPos.func_177982_a(-r, -25, -r), (BlockPos)genPos.func_177982_a(r, 4, r)).forEach(pos -> {
            if (pos.func_177956_o() < genPos.func_177956_o()) {
                double pct = (double)(genPos.func_177956_o() - pos.func_177956_o()) / 25.0;
                if (Utils.getDistanceAtoB((double)pos.func_177958_n(), (double)pos.func_177952_p(), (double)genPos.func_177958_n(), (double)genPos.func_177952_p()) <= (double)r + 0.5 && 1.0 - pct > rand.nextDouble()) {
                    float block = rand.nextFloat();
                    if ((double)block < 0.1) {
                        world.func_175656_a(new BlockPos((Vec3i)pos), DEFeatures.infusedObsidian.func_176223_P());
                    } else if ((double)block < 0.4) {
                        world.func_175656_a(new BlockPos((Vec3i)pos), Blocks.field_150385_bj.func_176223_P());
                    } else {
                        world.func_175656_a(new BlockPos((Vec3i)pos), Blocks.field_150343_Z.func_176223_P());
                    }
                }
            }
            int relY = pos.func_177956_o() - genPos.func_177956_o();
            int absRelX = Math.abs(pos.func_177958_n() - genPos.func_177958_n());
            int absRelZ = Math.abs(pos.func_177952_p() - genPos.func_177952_p());
            if ((absRelX == 2 || absRelZ == 2) && absRelX <= 2 && absRelZ <= 2 && relY < 4 && relY > -1) {
                world.func_175656_a(pos, Blocks.field_150411_aY.func_176223_P());
            }
            if (relY == 4 && absRelX <= 2 && absRelZ <= 2) {
                world.func_175656_a(pos, Blocks.field_150333_U.func_176203_a(6));
            }
        });
    }

    @Shadow(remap=false)
    private boolean hasBeenMoved() {
        return this.posLock.value != this.field_174879_c.func_177986_g() || this.dimLock.value != this.field_145850_b.field_73011_w.getDimension();
    }
}

