/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.endercore;

import com.enderio.core.common.util.stackable.Things;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.HashedItemStack;
import github.kasuminova.stellarcore.mixin.util.IIThing;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Things.class})
public class MixinThings {
    @Final
    @Nonnull
    @Shadow(remap=false)
    private List<Object> things;
    @Shadow(remap=false)
    private NBTTagCompound nbt;
    @Unique
    private final Map<HashedItemStack, Boolean> stellar_core$itemStackCache = new WeakHashMap<HashedItemStack, Boolean>();
    @Unique
    private final Map<Item, Boolean> stellar_core$itemCache = new WeakHashMap<Item, Boolean>();
    @Unique
    private final Map<Block, Boolean> stellar_core$blockCache = new WeakHashMap<Block, Boolean>();

    @Inject(method={"contains(Lnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectItemStackContains(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.enderCore.things) {
            return;
        }
        if (itemStack == null || itemStack.func_190926_b()) {
            cir.setReturnValue((Object)false);
            return;
        }
        HashedItemStack stack = HashedItemStack.ofTagUnsafe(itemStack);
        Boolean cache = this.stellar_core$itemStackCache.get(stack);
        if (cache != null) {
            cir.setReturnValue((Object)cache);
            return;
        }
        for (Object iThing : this.things) {
            IIThing thing = (IIThing)iThing;
            if (!thing.callIs(itemStack) || this.nbt != null && !this.nbt.equals((Object)itemStack.func_77978_p())) continue;
            this.stellar_core$itemStackCache.put(stack.copy(), true);
            cir.setReturnValue((Object)true);
            return;
        }
        this.stellar_core$itemStackCache.put(stack, false);
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"contains(Lnet/minecraft/item/Item;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectItemContains(Item item, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.enderCore.things) {
            return;
        }
        if (item == null || item != Items.field_190931_a) {
            cir.setReturnValue((Object)false);
            return;
        }
        Boolean cache = this.stellar_core$itemCache.get(item);
        if (cache != null) {
            cir.setReturnValue((Object)cache);
            return;
        }
        for (Object iThing : this.things) {
            IIThing thing = (IIThing)iThing;
            if (!thing.callIs(item)) continue;
            this.stellar_core$itemCache.put(item, true);
            cir.setReturnValue((Object)true);
            return;
        }
        this.stellar_core$itemCache.put(item, false);
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"contains(Lnet/minecraft/block/Block;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectItemContains(Block block, CallbackInfoReturnable<Boolean> cir) {
        if (!StellarCoreConfig.PERFORMANCE.enderCore.things) {
            return;
        }
        if (block == null || block == Blocks.field_150350_a) {
            cir.setReturnValue((Object)false);
            return;
        }
        Boolean cache = this.stellar_core$blockCache.get(block);
        if (cache != null) {
            cir.setReturnValue((Object)cache);
            return;
        }
        for (Object iThing : this.things) {
            IIThing thing = (IIThing)iThing;
            if (!thing.callIs(block)) continue;
            this.stellar_core$blockCache.put(block, true);
            cir.setReturnValue((Object)true);
            return;
        }
        this.stellar_core$blockCache.put(block, false);
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"cleanCachedValues"}, at={@At(value="RETURN")}, remap=false)
    private void injectCleanCachedValues(CallbackInfo ci) {
        this.stellar_core$itemStackCache.clear();
        this.stellar_core$itemCache.clear();
        this.stellar_core$blockCache.clear();
    }
}

