/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.enderio;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.config.ConfigHandler;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TileEntityBase.class})
public abstract class MixinTileEntityBase
extends TileEntity {
    @Shadow(remap=false)
    private long lastUpdate;

    @Shadow(remap=false)
    protected abstract void doUpdate();

    @Shadow(remap=false)
    protected abstract void sendProgressIf();

    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectUpdate(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.enderIO.tileEntityBase) {
            return;
        }
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if (ConfigHandler.allowExternalTickSpeedup || totalWorldTime != this.lastUpdate) {
            this.lastUpdate = totalWorldTime;
            this.doUpdate();
            this.sendProgressIf();
        }
        ci.cancel();
    }
}

