/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.enderioconduits_energy;

import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduits.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduits.conduit.power.PowerTracker;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.mixin.enderioconduits_energy.AccessorReceptorEntry;
import github.kasuminova.stellarcore.mixin.util.ICapBankSupply;
import github.kasuminova.stellarcore.mixin.util.IStellarNetworkPowerManager;
import github.kasuminova.stellarcore.mixin.util.ReceptorPowerInterface;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.profiler.Profiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetworkPowerManager.class}, remap=false)
public abstract class MixinNetworkPowerManager
implements IStellarNetworkPowerManager {
    @Shadow
    @Final
    @Nonnull
    private PowerTracker networkPowerTracker;
    @Shadow
    private long energyStored;
    @Shadow
    @Final
    @Nonnull
    private List<PowerConduitNetwork.ReceptorEntry> receptors;
    @Shadow
    @Final
    @Nonnull
    private List<PowerConduitNetwork.ReceptorEntry> storageReceptors;
    @Unique
    private final List<ReceptorPowerInterface> stellar_core$collectedPowerInterface = new ObjectArrayList();
    @Unique
    private volatile boolean stellar_core$shouldFinalApply = false;
    @Unique
    private static volatile MethodHandle stellar_core$getCapSupply = null;

    @Shadow
    protected abstract void trackerStartTick();

    @Shadow
    protected abstract void trackerEndTick();

    @Shadow
    protected abstract void trackerSend(@Nonnull IPowerConduit var1, int var2, boolean var3);

    @Shadow
    protected abstract void checkReceptors();

    @Shadow
    protected abstract void updateNetworkStorage();

    @Shadow
    protected abstract void distributeStorageToConduits();

    @Inject(method={"doApplyRecievedPower"}, at={@At(value="HEAD")}, cancellable=true)
    public void doApplyRecievedPower(Profiler theProfiler, CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.enderIOConduits.networkPowerManager) {
            return;
        }
        ci.cancel();
        this.trackerStartTick();
        this.checkReceptors();
    }

    @Override
    public void stellar_core$parallelTick() {
        this.updateNetworkStorage();
        this.networkPowerTracker.tickStart(this.energyStored);
        ICapBankSupply capSupply = this.stellar_core$getCapSupply();
        capSupply.invokeInit();
        long available = this.energyStored + (long)capSupply.getCanExtract();
        if (available <= 0L || this.receptors.isEmpty() && this.storageReceptors.isEmpty()) {
            this.trackerEndTick();
            this.networkPowerTracker.tickEnd(this.energyStored);
            this.stellar_core$shouldFinalApply = false;
            return;
        }
        this.stellar_core$collectedPowerInterface.clear();
        this.receptors.forEach(receptor -> {
            AccessorReceptorEntry accessorReceptorEntry = (AccessorReceptorEntry)receptor;
            IPowerInterface pp = accessorReceptorEntry.invokeGetPowerInterface();
            if (pp != null) {
                this.stellar_core$collectedPowerInterface.add(new ReceptorPowerInterface(pp, accessorReceptorEntry));
            }
        });
        this.stellar_core$shouldFinalApply = true;
    }

    @Override
    @Unique
    public void stellar_core$finalApplyReceivedPower() {
        long available;
        if (!StellarCoreConfig.PERFORMANCE.enderIOConduits.networkPowerManager) {
            return;
        }
        if (!this.stellar_core$shouldFinalApply) {
            return;
        }
        this.updateNetworkStorage();
        ICapBankSupply capSupply = this.stellar_core$getCapSupply();
        long wasAvailable = available = this.energyStored + (long)capSupply.getCanExtract();
        for (ReceptorPowerInterface rpp : this.stellar_core$collectedPowerInterface) {
            AccessorReceptorEntry r = rpp.receptor();
            IPowerInterface pp = rpp.pp();
            int canOffer = (int)Math.min((long)r.getEmmiter().getMaxEnergyExtracted(r.getDirection()), available);
            int used = Math.max(0, pp.receiveEnergy(canOffer, false));
            this.trackerSend(r.getEmmiter(), used, false);
            if ((available -= (long)used) > 0L) continue;
            break;
        }
        long used = wasAvailable - available;
        this.energyStored -= used;
        if (!capSupply.getCapBanks().isEmpty()) {
            long capBankChange = 0L;
            if (this.energyStored < 0L) {
                capBankChange = this.energyStored;
                this.energyStored = 0L;
            } else if (this.energyStored > 0L) {
                capBankChange = Math.min(this.energyStored, (long)capSupply.getCanFill());
                this.energyStored -= capBankChange;
            }
            if (capBankChange < 0L) {
                capSupply.invokeRemove(Math.abs(capBankChange));
            } else if (capBankChange > 0L) {
                this.energyStored += capSupply.invokeAdd(capBankChange);
            }
            capSupply.invokeBalance();
        }
        this.distributeStorageToConduits();
        this.trackerEndTick();
        this.networkPowerTracker.tickEnd(this.energyStored);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Unique
    private ICapBankSupply stellar_core$getCapSupply() {
        if (stellar_core$getCapSupply == null) {
            Class<NetworkPowerManager> clazz = NetworkPowerManager.class;
            // MONITORENTER : crazypants.enderio.conduits.conduit.power.NetworkPowerManager.class
            if (stellar_core$getCapSupply == null) {
                try {
                    stellar_core$getCapSupply = MethodHandles.lookup().unreflectGetter(NetworkPowerManager.class.getDeclaredField("capSupply"));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            // MONITOREXIT : clazz
        }
        try {
            return stellar_core$getCapSupply.invoke((NetworkPowerManager)this);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

