/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.extrabotany;

import com.meteor.extrabotany.common.block.fluid.ModFluid;
import com.meteor.extrabotany.common.block.tile.TileManaLiquefaction;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;

@Mixin(value={TileManaLiquefaction.class})
public abstract class MixinTileManaLiquefaction
extends TileMod {
    @Shadow(remap=false)
    public int energy;
    @Final
    @Shadow(remap=false)
    private static int MAX_ENERGY;

    @Shadow(remap=false)
    public abstract boolean isFull();

    @Shadow(remap=false)
    public abstract int getCurrentMana();

    @Shadow(remap=false)
    public abstract void recieveMana(int var1);

    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
    public void update(CallbackInfo ci) {
        EnumFacing[] facings;
        if (!StellarCoreConfig.BUG_FIXES.extraBotany.tileManaLiquefaction) {
            return;
        }
        ci.cancel();
        if (!ConfigHandler.DISABLE_MANALIQUEFICATION) {
            return;
        }
        int redstone = 0;
        for (EnumFacing facing : facings = EnumFacing.field_82609_l) {
            int redstoneSide = this.func_145831_w().func_175651_c(this.func_174877_v().func_177972_a(facing), facing);
            redstone = Math.max(redstone, redstoneSide);
        }
        for (EnumFacing facing : facings) {
            TileEntity te;
            BlockPos neighbor = this.func_174877_v().func_177972_a(facing);
            if (!this.field_145850_b.func_175667_e(neighbor) || (te = this.field_145850_b.func_175625_s(neighbor)) == null) continue;
            IFluidHandler storage = null;
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
                storage = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
            } else if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                storage = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            }
            if (storage != null) {
                if (redstone == 0) {
                    if (!this.isFull() && storage.drain(new FluidStack(ModFluid.fluidMana, 1), true) != null) {
                        ++this.energy;
                    }
                } else if (this.energy >= 25) {
                    this.energy -= storage.fill(new FluidStack(ModFluid.fluidMana, 25), true);
                }
            }
            int speed = ConfigHandler.MG_TRANSFERSPEED;
            if (!(te instanceof TileSpreader) || redstone != 0) continue;
            TileSpreader spreader = (TileSpreader)te;
            if (this.getCurrentMana() < speed || spreader.getCurrentMana() >= spreader.getMaxMana()) continue;
            int current = Math.min(speed, spreader.getMaxMana() - spreader.getCurrentMana());
            spreader.recieveMana(current);
            this.recieveMana(-current);
        }
        if (redstone == 0) {
            if (this.energy > 0 && this.getCurrentMana() <= 998000) {
                this.recieveMana(2000);
                this.energy -= 2;
            }
        } else if (this.getCurrentMana() >= 2000 && this.energy + 2 <= MAX_ENERGY) {
            this.recieveMana(-2000);
            this.energy += 2;
        }
    }
}

