/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.fluxnetworks;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.common.connection.transfer.ConnectionTransfer;

@Mixin(value={ConnectionTransfer.class}, remap=false)
public class MixinConnectionTransfer {
    @Shadow
    @Final
    private ITileEnergyHandler energyHandler;
    @Shadow
    @Final
    private TileEntity tile;
    @Shadow
    @Final
    private EnumFacing side;
    @Shadow
    public long inbound;
    @Unique
    private boolean stellar_core$canAddEnergy = false;

    @Inject(method={"sendToTile"}, at={@At(value="HEAD")}, cancellable=true)
    public void sendToTile(long amount, boolean simulate, CallbackInfoReturnable<Long> cir) {
        if (!StellarCoreConfig.PERFORMANCE.fluxNetworks.connectionTransfer) {
            return;
        }
        if (simulate) {
            if (this.energyHandler.canAddEnergy(this.tile, this.side)) {
                this.stellar_core$canAddEnergy = true;
                cir.setReturnValue((Object)this.energyHandler.addEnergy(amount, this.tile, this.side, true));
                return;
            }
            this.stellar_core$canAddEnergy = false;
            cir.setReturnValue((Object)0L);
            return;
        }
        if (this.stellar_core$canAddEnergy) {
            this.stellar_core$canAddEnergy = false;
            long added = this.energyHandler.addEnergy(amount, this.tile, this.side, false);
            this.inbound += added;
            cir.setReturnValue((Object)added);
            return;
        }
        cir.setReturnValue((Object)0L);
    }
}

