/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.fluxnetworks;

import com.mojang.authlib.GameProfile;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarEnvironment;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.mixin.util.IStellarFluxNetwork;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxPlug;
import sonar.fluxnetworks.api.tiles.IFluxPoint;
import sonar.fluxnetworks.api.utils.ICustomValue;
import sonar.fluxnetworks.common.connection.FluxNetworkBase;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.connection.PriorityGroup;
import sonar.fluxnetworks.common.connection.TransferIterator;
import sonar.fluxnetworks.common.connection.transfer.FluxControllerHandler;

@Mixin(value={FluxNetworkServer.class}, remap=false)
public abstract class MixinFluxNetworkServer
extends FluxNetworkBase
implements IFluxNetwork,
IStellarFluxNetwork {
    @Shadow
    public long bufferLimiter;
    @Shadow
    @Final
    private List<PriorityGroup<IFluxPoint>> sortedPoints;
    @Shadow
    @Final
    private List<PriorityGroup<IFluxPlug>> sortedPlugs;
    @Shadow
    @Final
    private TransferIterator<IFluxPlug> plugTransferIterator;
    @Shadow
    @Final
    private TransferIterator<IFluxPoint> pointTransferIterator;

    @Shadow
    protected abstract void handleConnectionQueue();

    @Override
    public Runnable getCycleStartRunnable() {
        this.handleConnectionQueue();
        return () -> {
            List devices = this.getConnections(FluxLogicType.ANY);
            devices.parallelStream().forEach(device -> {
                try {
                    ITransferHandler handler = device.getTransferHandler();
                    if (handler instanceof FluxControllerHandler) {
                        Class<FluxControllerHandler> clazz = FluxControllerHandler.class;
                        synchronized (FluxControllerHandler.class) {
                            handler.onCycleStart();
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return;
                        }
                    }
                    handler.onCycleStart();
                    return;
                }
                catch (Throwable e) {
                    StellarLog.LOG.warn("[StellarCore-FluxNetworkServer] Execute transfer handler `onCycleStart` failed.", e);
                }
            });
        };
    }

    @Inject(method={"onEndServerTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onEndServerTick(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.fluxNetworks.parallelNetworkCalculation || !StellarEnvironment.shouldParallel()) {
            return;
        }
        ci.cancel();
        ((NetworkStatistics)this.network_stats.getValue()).startProfiling();
        this.bufferLimiter = 0L;
        List devices = this.getConnections(FluxLogicType.ANY);
        if (!this.sortedPoints.isEmpty() && !this.sortedPlugs.isEmpty()) {
            this.plugTransferIterator.reset(this.sortedPlugs);
            this.pointTransferIterator.reset(this.sortedPoints);
            block0: while (this.pointTransferIterator.hasNext()) {
                while (this.plugTransferIterator.hasNext()) {
                    IFluxPlug plug = (IFluxPlug)this.plugTransferIterator.next();
                    IFluxPoint point = (IFluxPoint)this.pointTransferIterator.next();
                    if (plug.getConnectionType() == point.getConnectionType()) break block0;
                    long operate = plug.getTransferHandler().removeFromBuffer(point.getTransferHandler().getRequest());
                    if (operate > 0L) {
                        point.getTransferHandler().addToBuffer(operate);
                        continue block0;
                    }
                    this.plugTransferIterator.incrementFlux();
                }
                break block0;
            }
        }
        for (IFluxConnector f : devices) {
            f.getTransferHandler().onCycleEnd();
            this.bufferLimiter += f.getTransferHandler().getRequest();
        }
        ((NetworkStatistics)this.network_stats.getValue()).stopProfiling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getMemberPermission"}, at={@At(value="INVOKE", target="Lsonar/fluxnetworks/api/utils/ICustomValue;getValue()Ljava/lang/Object;", ordinal=0)}, cancellable=true)
    private void injectGetMemberPermission(EntityPlayer player, CallbackInfoReturnable<AccessLevel> cir) {
        if (!StellarCoreConfig.BUG_FIXES.fluxNetworks.synchronize) {
            return;
        }
        UUID uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        ICustomValue iCustomValue = this.network_players;
        synchronized (iCustomValue) {
            for (NetworkMember member : (List)this.network_players.getValue()) {
                if (!member.getPlayerUUID().equals(uuid)) continue;
                cir.setReturnValue((Object)member.getAccessPermission());
                return;
            }
            cir.setReturnValue((Object)(((SecurityType)this.network_security.getValue()).isEncrypted() ? AccessLevel.NONE : AccessLevel.USER));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"addNewMember"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectAddNewMember(String name, CallbackInfo ci) {
        if (!StellarCoreConfig.BUG_FIXES.fluxNetworks.synchronize) {
            return;
        }
        ci.cancel();
        NetworkMember newMember = NetworkMember.createMemberByUsername((String)name);
        ICustomValue iCustomValue = this.network_players;
        synchronized (iCustomValue) {
            List players = (List)this.network_players.getValue();
            for (NetworkMember player : players) {
                if (!player.getPlayerUUID().equals(newMember.getPlayerUUID())) continue;
                return;
            }
            players.add(newMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"removeMember"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRemoveMember(UUID uuid, CallbackInfo ci) {
        if (!StellarCoreConfig.BUG_FIXES.fluxNetworks.synchronize) {
            return;
        }
        ci.cancel();
        ICustomValue iCustomValue = this.network_players;
        synchronized (iCustomValue) {
            ((List)this.network_players.getValue()).removeIf(member -> member.getPlayerUUID().equals(uuid) && !member.getAccessPermission().canDelete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getValidMember"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectGetValidMember(UUID player, CallbackInfoReturnable<Optional<NetworkMember>> cir) {
        if (!StellarCoreConfig.BUG_FIXES.fluxNetworks.synchronize) {
            return;
        }
        ICustomValue iCustomValue = this.network_players;
        synchronized (iCustomValue) {
            cir.setReturnValue(((List)this.network_players.getValue()).stream().filter(f -> f.getPlayerUUID().equals(player)).findFirst());
        }
    }
}

