/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.fluxnetworks;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import sonar.fluxnetworks.api.network.ConnectionType;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.translate.Translation;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.integration.TOPIntegration;

@Mixin(value={TOPIntegration.FluxConnectorInfoProvider.class})
public class MixinTOPIntegration {
    @Redirect(method={"addProbeInfo"}, at=@At(value="INVOKE", target="Lsonar/fluxnetworks/api/translate/Translation;t()Ljava/lang/String;", remap=false), remap=false)
    public String redirectAddProbeInfoTrans(Translation instance) {
        if (!StellarCoreConfig.BUG_FIXES.fluxNetworks.fixTop) {
            return instance.t();
        }
        return MixinTOPIntegration.stellar_core$getTOPTransKey(instance);
    }

    @Redirect(method={"addProbeInfo"}, at=@At(value="INVOKE", target="Lsonar/fluxnetworks/common/core/FluxUtils;getTransferInfo(Lsonar/fluxnetworks/api/network/ConnectionType;Lsonar/fluxnetworks/api/utils/EnergyType;J)Ljava/lang/String;", remap=false), remap=false)
    public String redirectAddProbeInfoGetTransferInfo(ConnectionType connectionType, EnergyType energyType, long charge) {
        if (!StellarCoreConfig.BUG_FIXES.fluxNetworks.fixTop) {
            return FluxUtils.getTransferInfo((ConnectionType)connectionType, (EnergyType)energyType, (long)charge);
        }
        return MixinTOPIntegration.stellar_core$getTransferInfo(connectionType, energyType, charge);
    }

    @Unique
    private static String stellar_core$getTransferInfo(ConnectionType type, EnergyType energyType, long charge) {
        if (type.isPlug()) {
            String formatted = FluxUtils.format((long)charge, (FluxUtils.TypeNumberFormat)FluxUtils.TypeNumberFormat.COMMAS, (EnergyType)energyType, (boolean)true);
            return charge == 0L ? MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.INPUT) + ": " + TextFormatting.GOLD + formatted : MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.INPUT) + ": " + TextFormatting.GREEN + "+" + formatted;
        }
        if (!type.isPoint() && !type.isController()) {
            if (type != ConnectionType.STORAGE) {
                return "";
            }
            if (charge == 0L) {
                return MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.CHANGE) + ": " + TextFormatting.GOLD + charge + energyType.getUsageSuffix();
            }
            if (charge > 0L) {
                return MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.CHANGE) + ": " + TextFormatting.RED + "-" + FluxUtils.format((long)charge, (FluxUtils.TypeNumberFormat)FluxUtils.TypeNumberFormat.COMMAS, (EnergyType)energyType, (boolean)true);
            }
            return MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.CHANGE) + ": " + TextFormatting.GREEN + "+" + FluxUtils.format((long)(-charge), (FluxUtils.TypeNumberFormat)FluxUtils.TypeNumberFormat.COMMAS, (EnergyType)energyType, (boolean)true);
        }
        String formatted = FluxUtils.format((long)(-charge), (FluxUtils.TypeNumberFormat)FluxUtils.TypeNumberFormat.COMMAS, (EnergyType)energyType, (boolean)true);
        if (charge == 0L) {
            return MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.OUTPUT) + ": " + TextFormatting.GOLD + formatted;
        }
        return MixinTOPIntegration.stellar_core$getTOPTransKey(FluxTranslate.OUTPUT) + ": " + TextFormatting.RED + "-" + formatted;
    }

    @Unique
    private static String stellar_core$getTOPTransKey(Translation translation) {
        return "{*" + translation.key + "*}";
    }
}

