/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.forge.chunkmanager;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ForgeChunkManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ForgeChunkManager.class})
public abstract class MixinForgeChunkManager {
    @Nonnull
    @Shadow(remap=false)
    public static ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> getPersistentChunksFor(World world) {
        return null;
    }

    @Overwrite(remap=false)
    public static Iterator<Chunk> getPersistentChunksIterableFor(World world, Iterator<Chunk> chunkIterator) {
        ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> persistentChunksFor = MixinForgeChunkManager.getPersistentChunksFor(world);
        NonBlockingHashSet chunks = new NonBlockingHashSet();
        ObjectArrayList requiredToLoad = new ObjectArrayList();
        IChunkProvider chunkProvider = world.func_72863_F();
        world.field_72984_F.func_76318_c("regularChunkLoading");
        persistentChunksFor.keys().parallelStream().forEach(arg_0 -> MixinForgeChunkManager.lambda$getPersistentChunksIterableFor$0(chunkProvider, chunks, (List)requiredToLoad, arg_0));
        if (!requiredToLoad.isEmpty()) {
            world.field_72984_F.func_76318_c("forcedChunkLoading");
            requiredToLoad.forEach(pos -> chunks.add(chunkProvider.func_186025_d(pos.field_77276_a, pos.field_77275_b)));
        }
        world.field_72984_F.func_76319_b();
        return Iterators.concat(chunks.iterator(), chunkIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getPersistentChunksIterableFor$0(IChunkProvider chunkProvider, Set chunks, List requiredToLoad, ChunkPos pos) {
        Chunk loadedChunk = chunkProvider.func_186026_b(pos.field_77276_a, pos.field_77275_b);
        if (loadedChunk != null) {
            chunks.add(loadedChunk);
        } else {
            List list = requiredToLoad;
            synchronized (list) {
                requiredToLoad.add(pos);
            }
        }
    }
}

